/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;

public final class FileSystemTestHelper {
    public static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data") + "/test";
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private static final int DEFAULT_NUM_BLOCKS = 2;
    private static String absTestRootDir = null;
    public static final String __PARANAMER_DATA = "exists org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fSys,p \nisDir org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fSys,p \nisFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fSys,p \ngetFileData int,long numOfBlocks,blockSize \nreadFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,int fSys,path,len \ngetAbsoluteTestRootDir org.apache.hadoop.fs.FileSystem fSys \ncontainsPath org.apache.hadoop.fs.FileSystem,java.lang.String,org.apache.hadoop.fs.FileStatus[] fSys,path,dirList \ncontainsPath org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,org.apache.hadoop.fs.FileStatus[] fSys,path,dirList \ncontainsPath org.apache.hadoop.fs.Path,org.apache.hadoop.fs.FileStatus[] path,dirList \ncreateFile org.apache.hadoop.fs.FileSystem,java.lang.String fSys,name \ngetAbsoluteTestRootPath org.apache.hadoop.fs.FileSystem fSys \ngetDefaultWorkingDirectory org.apache.hadoop.fs.FileSystem fSys \ngetTestRootPath org.apache.hadoop.fs.FileSystem fSys \ngetTestRootPath org.apache.hadoop.fs.FileSystem,java.lang.String fSys,pathString \naddFileSystemForTesting java.net.URI,org.apache.hadoop.conf.Configuration,org.apache.hadoop.fs.FileSystem uri,conf,fs \ncheckFileStatus org.apache.hadoop.fs.FileSystem,java.lang.String,org.apache.hadoop.fs.FileSystemTestHelper.fileType aFs,path,expectedType \ncreateFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fSys,path \ncreateFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,int,int fSys,path,numBlocks,blockSize \ncreateFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,int,int,boolean fSys,path,numBlocks,blockSize,createParent \nwriteFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,byte[] fSys,path,b \n";

    private FileSystemTestHelper() {
    }

    public static void addFileSystemForTesting(URI uri, Configuration conf, FileSystem fs) throws IOException {
        FileSystem.addFileSystemForTesting((URI)uri, (Configuration)conf, (FileSystem)fs);
    }

    public static int getDefaultBlockSize() {
        return 1024;
    }

    public static byte[] getFileData(int numOfBlocks, long blockSize) {
        byte[] data = new byte[(int)((long)numOfBlocks * blockSize)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10);
        }
        return data;
    }

    public static Path getTestRootPath(FileSystem fSys) {
        return fSys.makeQualified(new Path(TEST_ROOT_DIR));
    }

    public static Path getTestRootPath(FileSystem fSys, String pathString) {
        return fSys.makeQualified(new Path(TEST_ROOT_DIR, pathString));
    }

    public static String getAbsoluteTestRootDir(FileSystem fSys) throws IOException {
        if (absTestRootDir == null) {
            absTestRootDir = TEST_ROOT_DIR.startsWith("/") ? TEST_ROOT_DIR : fSys.getWorkingDirectory().toString() + "/" + TEST_ROOT_DIR;
        }
        return absTestRootDir;
    }

    public static Path getAbsoluteTestRootPath(FileSystem fSys) throws IOException {
        return fSys.makeQualified(new Path(FileSystemTestHelper.getAbsoluteTestRootDir(fSys)));
    }

    public static Path getDefaultWorkingDirectory(FileSystem fSys) throws IOException {
        return FileSystemTestHelper.getTestRootPath(fSys, "/user/" + System.getProperty("user.name")).makeQualified(fSys.getUri(), fSys.getWorkingDirectory());
    }

    public static void createFile(FileSystem fSys, Path path, int numBlocks, int blockSize, boolean createParent) throws IOException {
        FSDataOutputStream out = fSys.create(path, false, 4096, fSys.getDefaultReplication(), (long)blockSize);
        byte[] data = FileSystemTestHelper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
    }

    public static void createFile(FileSystem fSys, Path path, int numBlocks, int blockSize) throws IOException {
        FileSystemTestHelper.createFile(fSys, path, numBlocks, blockSize, true);
    }

    public static void createFile(FileSystem fSys, Path path) throws IOException {
        FileSystemTestHelper.createFile(fSys, path, 2, 1024, true);
    }

    public static Path createFile(FileSystem fSys, String name) throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, name);
        FileSystemTestHelper.createFile(fSys, path);
        return path;
    }

    public static boolean exists(FileSystem fSys, Path p) throws IOException {
        return fSys.exists(p);
    }

    public static boolean isFile(FileSystem fSys, Path p) throws IOException {
        try {
            return fSys.getFileStatus(p).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean isDir(FileSystem fSys, Path p) throws IOException {
        try {
            return fSys.getFileStatus(p).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static void writeFile(FileSystem fSys, Path path, byte[] b) throws Exception {
        FSDataOutputStream out = fSys.create(path);
        out.write(b);
        out.close();
    }

    public static byte[] readFile(FileSystem fSys, Path path, int len) throws Exception {
        FSDataInputStream dis = fSys.open(path);
        byte[] buffer = new byte[len];
        IOUtils.readFully((InputStream)dis, (byte[])buffer, (int)0, (int)len);
        dis.close();
        return buffer;
    }

    public static FileStatus containsPath(FileSystem fSys, Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!FileSystemTestHelper.getTestRootPath(fSys, path.toString()).equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    public static FileStatus containsPath(Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!path.equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    public static FileStatus containsPath(FileSystem fSys, String path, FileStatus[] dirList) throws IOException {
        return FileSystemTestHelper.containsPath(fSys, new Path(path), dirList);
    }

    public static void checkFileStatus(FileSystem aFs, String path, fileType expectedType) throws IOException {
        FileStatus s = aFs.getFileStatus(new Path(path));
        Assert.assertNotNull((Object)s);
        if (expectedType == fileType.isDir) {
            Assert.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == fileType.isFile) {
            Assert.assertTrue((boolean)s.isFile());
        } else if (expectedType == fileType.isSymlink) {
            Assert.assertTrue((boolean)s.isSymlink());
        }
        Assert.assertEquals((Object)aFs.makeQualified(new Path(path)), (Object)s.getPath());
    }

    public static enum fileType {
        isDir,
        isFile,
        isSymlink;

        public static final String __PARANAMER_DATA = "";
    }
}

