/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;

public abstract class FileSystemContractBaseTest
extends TestCase {
    protected FileSystem fs;
    private byte[] data = new byte[this.getBlockSize() * 2];
    public static final String __PARANAMER_DATA = "path java.lang.String pathString \ncreateFile org.apache.hadoop.fs.Path path \n";

    public FileSystemContractBaseTest() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(i % 10);
        }
    }

    protected void tearDown() throws Exception {
        this.fs.delete(this.path("/test"), true);
    }

    protected int getBlockSize() {
        return 1024;
    }

    protected String getDefaultWorkingDirectory() {
        return "/user/" + System.getProperty("user.name");
    }

    protected boolean renameSupported() {
        return true;
    }

    public void testFsStatus() throws Exception {
        FsStatus fsStatus = this.fs.getStatus();
        FileSystemContractBaseTest.assertNotNull((Object)fsStatus);
        FileSystemContractBaseTest.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        FileSystemContractBaseTest.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        FileSystemContractBaseTest.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    public void testWorkingDirectory() throws Exception {
        Path workDir = this.path(this.getDefaultWorkingDirectory());
        FileSystemContractBaseTest.assertEquals((Object)workDir, (Object)this.fs.getWorkingDirectory());
        this.fs.setWorkingDirectory(this.path("."));
        FileSystemContractBaseTest.assertEquals((Object)workDir, (Object)this.fs.getWorkingDirectory());
        this.fs.setWorkingDirectory(this.path(".."));
        FileSystemContractBaseTest.assertEquals((Object)workDir.getParent(), (Object)this.fs.getWorkingDirectory());
        Path relativeDir = this.path("hadoop");
        this.fs.setWorkingDirectory(relativeDir);
        FileSystemContractBaseTest.assertEquals((Object)relativeDir, (Object)this.fs.getWorkingDirectory());
        Path absoluteDir = this.path("/test/hadoop");
        this.fs.setWorkingDirectory(absoluteDir);
        FileSystemContractBaseTest.assertEquals((Object)absoluteDir, (Object)this.fs.getWorkingDirectory());
    }

    public void testMkdirs() throws Exception {
        Path testDir = this.path("/test/hadoop");
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(testDir));
        Path parentDir = testDir.getParent();
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(parentDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(parentDir));
        Path grandparentDir = parentDir.getParent();
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(grandparentDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(grandparentDir));
    }

    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.path("/test/hadoop");
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(testDir));
        this.createFile(this.path("/test/hadoop/file"));
        Path testSubDir = this.path("/test/hadoop/file/subdir");
        try {
            this.fs.mkdirs(testSubDir);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testSubDir));
        Path testDeepSubDir = this.path("/test/hadoop/file/deep/sub/dir");
        try {
            this.fs.mkdirs(testDeepSubDir);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDeepSubDir));
    }

    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fs.getFileStatus(this.path("/test/hadoop/file"));
            FileSystemContractBaseTest.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fs.listStatus(this.path("/test/hadoop/file"));
            FileSystemContractBaseTest.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{this.path("/test/hadoop/a"), this.path("/test/hadoop/b"), this.path("/test/hadoop/c/1")};
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDirs[0]));
        for (Path path : testDirs) {
            FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(path));
        }
        FileStatus[] paths = this.fs.listStatus(this.path("/test"));
        FileSystemContractBaseTest.assertEquals((int)1, (int)paths.length);
        FileSystemContractBaseTest.assertEquals((Object)this.path("/test/hadoop"), (Object)paths[0].getPath());
        paths = this.fs.listStatus(this.path("/test/hadoop"));
        FileSystemContractBaseTest.assertEquals((int)3, (int)paths.length);
        FileSystemContractBaseTest.assertEquals((Object)this.path("/test/hadoop/a"), (Object)paths[0].getPath());
        FileSystemContractBaseTest.assertEquals((Object)this.path("/test/hadoop/b"), (Object)paths[1].getPath());
        FileSystemContractBaseTest.assertEquals((Object)this.path("/test/hadoop/c"), (Object)paths[2].getPath());
        paths = this.fs.listStatus(this.path("/test/hadoop/a"));
        FileSystemContractBaseTest.assertEquals((int)0, (int)paths.length);
    }

    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() / 2);
    }

    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(this.getBlockSize());
    }

    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() + this.getBlockSize() / 2);
    }

    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() * 2);
    }

    private void writeReadAndDelete(int len) throws IOException {
        Path path = this.path("/test/hadoop/file");
        this.fs.mkdirs(path.getParent());
        FSDataOutputStream out = this.fs.create(path, false, this.fs.getConf().getInt("io.file.buffer.size", 4096), (short)1, (long)this.getBlockSize());
        out.write(this.data, 0, len);
        out.close();
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)len, (long)this.fs.getFileStatus(path).getLen());
        FSDataInputStream in = this.fs.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        FileSystemContractBaseTest.assertEquals((int)len, (int)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            FileSystemContractBaseTest.assertEquals((String)("Position " + i), (byte)this.data[i], (byte)buf[i]);
        }
        FileSystemContractBaseTest.assertTrue((String)"Deleted", (boolean)this.fs.delete(path, false));
        FileSystemContractBaseTest.assertFalse((String)"No longer exists", (boolean)this.fs.exists(path));
    }

    public void testOverwrite() throws IOException {
        Path path = this.path("/test/hadoop/file");
        this.fs.mkdirs(path.getParent());
        this.createFile(path);
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)this.data.length, (long)this.fs.getFileStatus(path).getLen());
        try {
            this.fs.create(path, false);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FSDataOutputStream out = this.fs.create(path, true);
        out.write(this.data, 0, this.data.length);
        out.close();
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)this.data.length, (long)this.fs.getFileStatus(path).getLen());
    }

    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = this.path("/test/hadoop/file");
        FileSystemContractBaseTest.assertFalse((String)"Parent doesn't exist", (boolean)this.fs.exists(path.getParent()));
        this.createFile(path);
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)this.data.length, (long)this.fs.getFileStatus(path).getLen());
        FileSystemContractBaseTest.assertTrue((String)"Parent exists", (boolean)this.fs.exists(path.getParent()));
    }

    public void testDeleteNonExistentFile() throws IOException {
        Path path = this.path("/test/hadoop/file");
        FileSystemContractBaseTest.assertFalse((String)"Doesn't exist", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertFalse((String)"No deletion", (boolean)this.fs.delete(path, true));
    }

    public void testDeleteRecursively() throws IOException {
        Path dir = this.path("/test/hadoop");
        Path file = this.path("/test/hadoop/file");
        Path subdir = this.path("/test/hadoop/subdir");
        this.createFile(file);
        FileSystemContractBaseTest.assertTrue((String)"Created subdir", (boolean)this.fs.mkdirs(subdir));
        FileSystemContractBaseTest.assertTrue((String)"File exists", (boolean)this.fs.exists(file));
        FileSystemContractBaseTest.assertTrue((String)"Dir exists", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertTrue((String)"Subdir exists", (boolean)this.fs.exists(subdir));
        try {
            this.fs.delete(dir, false);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FileSystemContractBaseTest.assertTrue((String)"File still exists", (boolean)this.fs.exists(file));
        FileSystemContractBaseTest.assertTrue((String)"Dir still exists", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertTrue((String)"Subdir still exists", (boolean)this.fs.exists(subdir));
        FileSystemContractBaseTest.assertTrue((String)"Deleted", (boolean)this.fs.delete(dir, true));
        FileSystemContractBaseTest.assertFalse((String)"File doesn't exist", (boolean)this.fs.exists(file));
        FileSystemContractBaseTest.assertFalse((String)"Dir doesn't exist", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertFalse((String)"Subdir doesn't exist", (boolean)this.fs.exists(subdir));
    }

    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = this.path("/test/hadoop");
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(dir));
        FileSystemContractBaseTest.assertTrue((String)"Dir exists", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertTrue((String)"Deleted", (boolean)this.fs.delete(dir, false));
        FileSystemContractBaseTest.assertFalse((String)"Dir doesn't exist", (boolean)this.fs.exists(dir));
    }

    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/path");
        Path dst = this.path("/test/new/newpath");
        this.rename(src, dst, false, false, false);
    }

    public void testRenameFileMoveToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/file");
        this.createFile(src);
        Path dst = this.path("/test/new/newfile");
        this.rename(src, dst, false, true, false);
    }

    public void testRenameFileMoveToExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/file");
        this.createFile(src);
        Path dst = this.path("/test/new/newfile");
        this.fs.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true);
    }

    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/file");
        this.createFile(src);
        Path dst = this.path("/test/new/newfile");
        this.createFile(dst);
        this.rename(src, dst, false, true, true);
    }

    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/file");
        this.createFile(src);
        Path dst = this.path("/test/new/newdir");
        this.fs.mkdirs(dst);
        this.rename(src, dst, true, false, true);
        FileSystemContractBaseTest.assertTrue((String)"Destination changed", (boolean)this.fs.exists(this.path("/test/new/newdir/file")));
    }

    public void testRenameDirectoryMoveToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/dir");
        this.fs.mkdirs(src);
        Path dst = this.path("/test/new/newdir");
        this.rename(src, dst, false, true, false);
    }

    public void testRenameDirectoryMoveToExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/dir");
        this.fs.mkdirs(src);
        this.createFile(this.path("/test/hadoop/dir/file1"));
        this.createFile(this.path("/test/hadoop/dir/subdir/file2"));
        Path dst = this.path("/test/new/newdir");
        this.fs.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true);
        FileSystemContractBaseTest.assertFalse((String)"Nested file1 exists", (boolean)this.fs.exists(this.path("/test/hadoop/dir/file1")));
        FileSystemContractBaseTest.assertFalse((String)"Nested file2 exists", (boolean)this.fs.exists(this.path("/test/hadoop/dir/subdir/file2")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested file1 exists", (boolean)this.fs.exists(this.path("/test/new/newdir/file1")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested exists", (boolean)this.fs.exists(this.path("/test/new/newdir/subdir/file2")));
    }

    public void testRenameDirectoryAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/dir");
        this.fs.mkdirs(src);
        Path dst = this.path("/test/new/newfile");
        this.createFile(dst);
        this.rename(src, dst, false, true, true);
    }

    public void testRenameDirectoryAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("/test/hadoop/dir");
        this.fs.mkdirs(src);
        this.createFile(this.path("/test/hadoop/dir/file1"));
        this.createFile(this.path("/test/hadoop/dir/subdir/file2"));
        Path dst = this.path("/test/new/newdir");
        this.fs.mkdirs(dst);
        this.rename(src, dst, true, false, true);
        FileSystemContractBaseTest.assertTrue((String)"Destination changed", (boolean)this.fs.exists(this.path("/test/new/newdir/dir")));
        FileSystemContractBaseTest.assertFalse((String)"Nested file1 exists", (boolean)this.fs.exists(this.path("/test/hadoop/dir/file1")));
        FileSystemContractBaseTest.assertFalse((String)"Nested file2 exists", (boolean)this.fs.exists(this.path("/test/hadoop/dir/subdir/file2")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested file1 exists", (boolean)this.fs.exists(this.path("/test/new/newdir/dir/file1")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested exists", (boolean)this.fs.exists(this.path("/test/new/newdir/dir/subdir/file2")));
    }

    public void testInputStreamClosedTwice() throws IOException {
        Path src = this.path("/test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = this.fs.open(src);
        in.close();
        in.close();
    }

    public void testOutputStreamClosedTwice() throws IOException {
        Path src = this.path("/test/hadoop/file");
        FSDataOutputStream out = this.fs.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    protected Path path(String pathString) {
        return new Path(pathString).makeQualified(this.fs);
    }

    protected void createFile(Path path) throws IOException {
        FSDataOutputStream out = this.fs.create(path);
        out.write(this.data, 0, this.data.length);
        out.close();
    }

    private void rename(Path src, Path dst, boolean renameSucceeded, boolean srcExists, boolean dstExists) throws IOException {
        FileSystemContractBaseTest.assertEquals((String)"Rename result", (boolean)renameSucceeded, (boolean)this.fs.rename(src, dst));
        FileSystemContractBaseTest.assertEquals((String)"Source exists", (boolean)srcExists, (boolean)this.fs.exists(src));
        FileSystemContractBaseTest.assertEquals((String)"Destination exists", (boolean)dstExists, (boolean)this.fs.exists(dst));
    }
}

