/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;

public final class FileContextTestHelper {
    public static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data") + "/test";
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private static final int DEFAULT_NUM_BLOCKS = 2;
    private static String absTestRootDir = null;
    public static final String __PARANAMER_DATA = "exists org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path fc,p \nisDir org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path fc,p \nisFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path fc,p \nisSymlink org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path fc,p \ngetFileData int,long numOfBlocks,blockSize \nreadFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path,int fc,path,len \ngetAbsoluteTestRootDir org.apache.hadoop.fs.FileContext fc \ncontainsPath org.apache.hadoop.fs.FileContext,java.lang.String,org.apache.hadoop.fs.FileStatus[] fc,path,dirList \ncontainsPath org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path,org.apache.hadoop.fs.FileStatus[] fc,path,dirList \ncontainsPath org.apache.hadoop.fs.Path,org.apache.hadoop.fs.FileStatus[] path,dirList \ncreateFile org.apache.hadoop.fs.FileContext,java.lang.String fc,name \ngetAbsoluteTestRootPath org.apache.hadoop.fs.FileContext fc \ngetDefaultWorkingDirectory org.apache.hadoop.fs.FileContext fc \ngetTestRootPath org.apache.hadoop.fs.FileContext fc \ngetTestRootPath org.apache.hadoop.fs.FileContext,java.lang.String fc,pathString \nappendToFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path,int,org.apache.hadoop.fs.Options.CreateOpts fc,path,numBlocks,options \ncheckFileLinkStatus org.apache.hadoop.fs.FileContext,java.lang.String,org.apache.hadoop.fs.FileContextTestHelper.fileType aFc,path,expectedType \ncheckFileStatus org.apache.hadoop.fs.FileContext,java.lang.String,org.apache.hadoop.fs.FileContextTestHelper.fileType aFc,path,expectedType \ncreateFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path fc,path \ncreateFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path,int,int fc,path,numBlocks,blockSize \ncreateFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path,int,org.apache.hadoop.fs.Options.CreateOpts fc,path,numBlocks,options \ncreateFileNonRecursive org.apache.hadoop.fs.FileContext,java.lang.String fc,name \ncreateFileNonRecursive org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path fc,path \nwriteFile org.apache.hadoop.fs.FileContext,org.apache.hadoop.fs.Path,byte[] fc,path,b \n";

    private FileContextTestHelper() {
    }

    public static int getDefaultBlockSize() {
        return 1024;
    }

    public static byte[] getFileData(int numOfBlocks, long blockSize) {
        byte[] data = new byte[(int)((long)numOfBlocks * blockSize)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10);
        }
        return data;
    }

    public static Path getTestRootPath(FileContext fc) {
        return fc.makeQualified(new Path(TEST_ROOT_DIR));
    }

    public static Path getTestRootPath(FileContext fc, String pathString) {
        return fc.makeQualified(new Path(TEST_ROOT_DIR, pathString));
    }

    public static String getAbsoluteTestRootDir(FileContext fc) throws IOException {
        if (absTestRootDir == null) {
            absTestRootDir = TEST_ROOT_DIR.startsWith("/") ? TEST_ROOT_DIR : fc.getWorkingDirectory().toString() + "/" + TEST_ROOT_DIR;
        }
        return absTestRootDir;
    }

    public static Path getAbsoluteTestRootPath(FileContext fc) throws IOException {
        return fc.makeQualified(new Path(FileContextTestHelper.getAbsoluteTestRootDir(fc)));
    }

    public static Path getDefaultWorkingDirectory(FileContext fc) throws IOException {
        return FileContextTestHelper.getTestRootPath(fc, "/user/" + System.getProperty("user.name")).makeQualified(fc.getDefaultFileSystem().getUri(), fc.getWorkingDirectory());
    }

    public static void createFile(FileContext fc, Path path, int numBlocks, Options.CreateOpts ... options) throws IOException {
        Options.CreateOpts.BlockSize blockSizeOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])options);
        long blockSize = blockSizeOpt != null ? blockSizeOpt.getValue() : 1024L;
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), options);
        byte[] data = FileContextTestHelper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
    }

    public static void createFile(FileContext fc, Path path, int numBlocks, int blockSize) throws IOException {
        FileContextTestHelper.createFile(fc, path, numBlocks, new Options.CreateOpts[]{Options.CreateOpts.blockSize((long)blockSize), Options.CreateOpts.createParent()});
    }

    public static void createFile(FileContext fc, Path path) throws IOException {
        FileContextTestHelper.createFile(fc, path, 2, new Options.CreateOpts[]{Options.CreateOpts.createParent()});
    }

    public static Path createFile(FileContext fc, String name) throws IOException {
        Path path = FileContextTestHelper.getTestRootPath(fc, name);
        FileContextTestHelper.createFile(fc, path);
        return path;
    }

    public static void createFileNonRecursive(FileContext fc, String name) throws IOException {
        Path path = FileContextTestHelper.getTestRootPath(fc, name);
        FileContextTestHelper.createFileNonRecursive(fc, path);
    }

    public static void createFileNonRecursive(FileContext fc, Path path) throws IOException {
        FileContextTestHelper.createFile(fc, path, 2, new Options.CreateOpts[]{Options.CreateOpts.donotCreateParent()});
    }

    public static void appendToFile(FileContext fc, Path path, int numBlocks, Options.CreateOpts ... options) throws IOException {
        Options.CreateOpts.BlockSize blockSizeOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])options);
        long blockSize = blockSizeOpt != null ? blockSizeOpt.getValue() : 1024L;
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]);
        byte[] data = FileContextTestHelper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
    }

    public static boolean exists(FileContext fc, Path p) throws IOException {
        return fc.util().exists(p);
    }

    public static boolean isFile(FileContext fc, Path p) throws IOException {
        try {
            return fc.getFileStatus(p).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean isDir(FileContext fc, Path p) throws IOException {
        try {
            return fc.getFileStatus(p).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean isSymlink(FileContext fc, Path p) throws IOException {
        try {
            return fc.getFileLinkStatus(p).isSymlink();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static void writeFile(FileContext fc, Path path, byte[] b) throws IOException {
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.write(b);
        out.close();
    }

    public static byte[] readFile(FileContext fc, Path path, int len) throws IOException {
        FSDataInputStream dis = fc.open(path);
        byte[] buffer = new byte[len];
        IOUtils.readFully((InputStream)dis, (byte[])buffer, (int)0, (int)len);
        dis.close();
        return buffer;
    }

    public static FileStatus containsPath(FileContext fc, Path path, FileStatus[] dirList) throws IOException {
        return FileContextTestHelper.containsPath(FileContextTestHelper.getTestRootPath(fc, path.toString()), dirList);
    }

    public static FileStatus containsPath(Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!path.equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    public static FileStatus containsPath(FileContext fc, String path, FileStatus[] dirList) throws IOException {
        return FileContextTestHelper.containsPath(fc, new Path(path), dirList);
    }

    public static void checkFileStatus(FileContext aFc, String path, fileType expectedType) throws IOException {
        FileStatus s = aFc.getFileStatus(new Path(path));
        Assert.assertNotNull((Object)s);
        if (expectedType == fileType.isDir) {
            Assert.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == fileType.isFile) {
            Assert.assertTrue((boolean)s.isFile());
        } else if (expectedType == fileType.isSymlink) {
            Assert.assertTrue((boolean)s.isSymlink());
        }
        Assert.assertEquals((Object)aFc.makeQualified(new Path(path)), (Object)s.getPath());
    }

    public static void checkFileLinkStatus(FileContext aFc, String path, fileType expectedType) throws IOException {
        FileStatus s = aFc.getFileLinkStatus(new Path(path));
        Assert.assertNotNull((Object)s);
        if (expectedType == fileType.isDir) {
            Assert.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == fileType.isFile) {
            Assert.assertTrue((boolean)s.isFile());
        } else if (expectedType == fileType.isSymlink) {
            Assert.assertTrue((boolean)s.isSymlink());
        }
        Assert.assertEquals((Object)aFc.makeQualified(new Path(path)), (Object)s.getPath());
    }

    public static enum fileType {
        isDir,
        isFile,
        isSymlink;

        public static final String __PARANAMER_DATA = "";
    }
}

