/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.hadoop.conf.ConfServlet;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestConfServlet
extends TestCase {
    private static final String TEST_KEY = "testconfservlet.key";
    private static final String TEST_VAL = "testval";
    public static final String __PARANAMER_DATA = "";

    private Configuration getTestConf() {
        Configuration testConf = new Configuration();
        testConf.set(TEST_KEY, TEST_VAL);
        return testConf;
    }

    @Test
    public void testWriteJson() throws Exception {
        Object[] properties;
        StringWriter sw = new StringWriter();
        ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"json");
        String json = sw.toString();
        boolean foundSetting = false;
        Object parsed = JSON.parse((String)json);
        for (Object o : properties = (Object[])((Map)parsed).get("properties")) {
            Map propertyInfo = (Map)o;
            String key = (String)propertyInfo.get("key");
            String val = (String)propertyInfo.get("value");
            String resource = (String)propertyInfo.get("resource");
            System.err.println("k: " + key + " v: " + val + " r: " + resource);
            if (!TEST_KEY.equals(key) || !TEST_VAL.equals(val) || !"Unknown".equals(resource)) continue;
            foundSetting = true;
        }
        TestConfServlet.assertTrue((boolean)foundSetting);
    }

    @Test
    public void testWriteXml() throws Exception {
        StringWriter sw = new StringWriter();
        ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"xml");
        String xml = sw.toString();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        NodeList nameNodes = doc.getElementsByTagName("name");
        boolean foundSetting = false;
        for (int i = 0; i < nameNodes.getLength(); ++i) {
            Node nameNode = nameNodes.item(i);
            String key = nameNode.getTextContent();
            System.err.println("xml key: " + key);
            if (!TEST_KEY.equals(key)) continue;
            foundSetting = true;
            Element propertyElem = (Element)nameNode.getParentNode();
            String val = propertyElem.getElementsByTagName("value").item(0).getTextContent();
            TestConfServlet.assertEquals((String)TEST_VAL, (String)val);
        }
        TestConfServlet.assertTrue((boolean)foundSetting);
    }

    @Test
    public void testBadFormat() throws Exception {
        StringWriter sw = new StringWriter();
        try {
            ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"not a format");
            TestConfServlet.fail((String)"writeResponse with bad format didn't throw!");
        }
        catch (ConfServlet.BadFormatException badFormatException) {
            // empty catch block
        }
        TestConfServlet.assertEquals((String)__PARANAMER_DATA, (String)sw.toString());
    }
}

