/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.hadoop.cli.CLITestHelper;

public abstract class CommandExecutor {
    public static final String __PARANAMER_DATA = "getCommandAsArgs java.lang.String,java.lang.String,java.lang.String cmd,masterKey,master \nexecuteCommand java.lang.String cmd \nexecute java.lang.String cmd \n";

    protected String[] getCommandAsArgs(String cmd, String masterKey, String master) {
        StringTokenizer tokenizer = new StringTokenizer(cmd, " ");
        String[] args = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            args[i] = tokenizer.nextToken();
            args[i] = args[i].replaceAll(masterKey, master);
            args[i] = args[i].replaceAll("CLITEST_DATA", new File(CLITestHelper.TEST_CACHE_DATA_DIR).toURI().toString().replace(' ', '+'));
            args[i] = args[i].replaceAll("TEST_DIR_ABSOLUTE", "/tmp/testcli");
            args[i] = args[i].replaceAll("USERNAME", System.getProperty("user.name"));
            ++i;
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result executeCommand(String cmd) throws Exception {
        int exitCode = 0;
        Exception lastException = null;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        try {
            this.execute(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            lastException = e;
            exitCode = -1;
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        return new Result(bao.toString(), exitCode, lastException, cmd);
    }

    protected abstract void execute(String var1) throws Exception;

    public static class Result {
        final String commandOutput;
        final int exitCode;
        final Exception exception;
        final String cmdExecuted;
        public static final String __PARANAMER_DATA = "<init> java.lang.String,int,java.lang.Exception,java.lang.String commandOutput,exitCode,exception,cmdExecuted \n";

        public Result(String commandOutput, int exitCode, Exception exception, String cmdExecuted) {
            this.commandOutput = commandOutput;
            this.exitCode = exitCode;
            this.exception = exception;
            this.cmdExecuted = cmdExecuted;
        }

        public String getCommandOutput() {
            return this.commandOutput;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public Exception getException() {
            return this.exception;
        }

        public String getCommand() {
            return this.cmdExecuted;
        }
    }
}

