/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.cli.util.CLITestData;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.cli.util.ComparatorBase;
import org.apache.hadoop.cli.util.ComparatorData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CLITestHelper {
    private static final Log LOG = LogFactory.getLog((String)CLITestHelper.class.getName());
    public static final String TESTMODE_TEST = "test";
    public static final String TESTMODE_NOCOMPARE = "nocompare";
    public static final String TEST_CACHE_DATA_DIR = System.getProperty("test.cache.data", "build/test/cache");
    public static final String TEST_DIR_ABSOLUTE = "/tmp/testcli";
    protected static String testDirAbsolute = "/tmp/testcli";
    protected String testMode = "test";
    protected ArrayList<CLITestData> testsFromConfigFile = null;
    protected ArrayList<ComparatorData> testComparators = null;
    protected String thisTestCaseName = null;
    protected ComparatorData comparatorData = null;
    protected Configuration conf = null;
    protected String clitestDataDir = null;
    protected String username = null;
    public static final String __PARANAMER_DATA = "expandCommand java.lang.String cmd \nexecute org.apache.hadoop.cli.util.CLITestData.TestCmd cmd \n";

    protected void readTestConfigFile() {
        String testConfigFile = this.getTestFile();
        if (this.testsFromConfigFile == null) {
            boolean success = false;
            String configFile = System.getProperty("test.cli.config");
            testConfigFile = configFile == null ? TEST_CACHE_DATA_DIR + File.separator + testConfigFile : configFile;
            try {
                SAXParser p = SAXParserFactory.newInstance().newSAXParser();
                p.parse(testConfigFile, (DefaultHandler)new TestConfigFileParser());
                LOG.info((Object)("Using test config file " + testConfigFile));
                success = true;
            }
            catch (Exception e) {
                LOG.info((Object)("File: " + testConfigFile + " not found"));
                success = false;
            }
            Assert.assertTrue((String)"Error reading test config file", (boolean)success);
        }
    }

    protected String getTestFile() {
        return "";
    }

    public void setUp() throws Exception {
        this.readTestConfigFile();
        this.conf = new Configuration();
        this.conf.setBoolean("hadoop.security.authorization", true);
        this.clitestDataDir = new File(TEST_CACHE_DATA_DIR).toURI().toString().replace(' ', '+');
        this.conf.setInt("dfs.replication", 1);
    }

    public void tearDown() throws Exception {
        this.displayResults();
    }

    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("CLITEST_DATA", this.clitestDataDir);
        expCmd = expCmd.replaceAll("USERNAME", this.username);
        expCmd = expCmd.replaceAll("TEST_DIR_ABSOLUTE", testDirAbsolute);
        return expCmd;
    }

    private void displayResults() {
        int i;
        LOG.info((Object)"Detailed results:");
        LOG.info((Object)"----------------------------------\n");
        for (int i2 = 0; i2 < this.testsFromConfigFile.size(); ++i2) {
            CLITestData td = this.testsFromConfigFile.get(i2);
            boolean testResult = td.getTestResult();
            if (testResult) continue;
            LOG.info((Object)"-------------------------------------------");
            LOG.info((Object)("                    Test ID: [" + (i2 + 1) + "]"));
            LOG.info((Object)("           Test Description: [" + td.getTestDesc() + "]"));
            LOG.info((Object)"");
            ArrayList<CLITestData.TestCmd> testCommands = td.getTestCommands();
            for (CLITestData.TestCmd cmd : testCommands) {
                LOG.info((Object)("              Test Commands: [" + this.expandCommand(cmd.getCmd()) + "]"));
            }
            LOG.info((Object)"");
            ArrayList<CLITestData.TestCmd> cleanupCommands = td.getCleanupCommands();
            for (CLITestData.TestCmd cmd : cleanupCommands) {
                LOG.info((Object)("           Cleanup Commands: [" + this.expandCommand(cmd.getCmd()) + "]"));
            }
            LOG.info((Object)"");
            ArrayList<ComparatorData> compdata = td.getComparatorData();
            for (ComparatorData cd : compdata) {
                boolean resultBoolean = cd.getTestResult();
                LOG.info((Object)("                 Comparator: [" + cd.getComparatorType() + "]"));
                LOG.info((Object)("         Comparision result:   [" + (resultBoolean ? "pass" : "fail") + "]"));
                LOG.info((Object)("            Expected output:   [" + cd.getExpectedOutput() + "]"));
                LOG.info((Object)("              Actual output:   [" + cd.getActualOutput() + "]"));
            }
            LOG.info((Object)"");
        }
        LOG.info((Object)"Summary results:");
        LOG.info((Object)"----------------------------------\n");
        boolean overallResults = true;
        int totalPass = 0;
        int totalFail = 0;
        int totalComparators = 0;
        for (i = 0; i < this.testsFromConfigFile.size(); ++i) {
            CLITestData td = this.testsFromConfigFile.get(i);
            totalComparators += this.testsFromConfigFile.get(i).getComparatorData().size();
            boolean resultBoolean = td.getTestResult();
            if (resultBoolean) {
                ++totalPass;
            } else {
                ++totalFail;
            }
            overallResults &= resultBoolean;
        }
        LOG.info((Object)("               Testing mode: " + this.testMode));
        LOG.info((Object)"");
        LOG.info((Object)("             Overall result: " + (overallResults ? "+++ PASS +++" : "--- FAIL ---")));
        if (totalPass + totalFail == 0) {
            LOG.info((Object)"               # Tests pass: 0");
            LOG.info((Object)"               # Tests fail: 0");
        } else {
            LOG.info((Object)("               # Tests pass: " + totalPass + " (" + 100 * totalPass / (totalPass + totalFail) + "%)"));
            LOG.info((Object)("               # Tests fail: " + totalFail + " (" + 100 * totalFail / (totalPass + totalFail) + "%)"));
        }
        LOG.info((Object)("         # Validations done: " + totalComparators + " (each test may do multiple validations)"));
        LOG.info((Object)"");
        LOG.info((Object)"Failing tests:");
        LOG.info((Object)"--------------");
        i = 0;
        boolean foundTests = false;
        for (i = 0; i < this.testsFromConfigFile.size(); ++i) {
            boolean resultBoolean = this.testsFromConfigFile.get(i).getTestResult();
            if (resultBoolean) continue;
            LOG.info((Object)(i + 1 + ": " + this.testsFromConfigFile.get(i).getTestDesc()));
            foundTests = true;
        }
        if (!foundTests) {
            LOG.info((Object)"NONE");
        }
        foundTests = false;
        LOG.info((Object)"");
        LOG.info((Object)"Passing tests:");
        LOG.info((Object)"--------------");
        for (i = 0; i < this.testsFromConfigFile.size(); ++i) {
            boolean resultBoolean = this.testsFromConfigFile.get(i).getTestResult();
            if (!resultBoolean) continue;
            LOG.info((Object)(i + 1 + ": " + this.testsFromConfigFile.get(i).getTestDesc()));
            foundTests = true;
        }
        if (!foundTests) {
            LOG.info((Object)"NONE");
        }
        Assert.assertTrue((String)"One of the tests failed. See the Detailed results to identify the command that failed", (boolean)overallResults);
    }

    private boolean compareTestOutput(ComparatorData compdata, CommandExecutor.Result cmdResult) {
        String comparatorType = compdata.getComparatorType();
        Class<?> comparatorClass = null;
        boolean compareOutput = false;
        if (this.testMode.equals(TESTMODE_TEST)) {
            try {
                comparatorClass = Class.forName("org.apache.hadoop.cli.util." + comparatorType);
                ComparatorBase comp = (ComparatorBase)comparatorClass.newInstance();
                compareOutput = comp.compare(cmdResult.getCommandOutput(), compdata.getExpectedOutput());
            }
            catch (Exception e) {
                LOG.info((Object)("Error in instantiating the comparator" + e));
            }
        }
        return compareOutput;
    }

    public void testAll() {
        Assert.assertTrue((String)"Number of tests has to be greater then zero", (this.testsFromConfigFile.size() > 0 ? 1 : 0) != 0);
        LOG.info((Object)"TestAll");
        for (int index = 0; index < this.testsFromConfigFile.size(); ++index) {
            CLITestData testdata = this.testsFromConfigFile.get(index);
            ArrayList<CLITestData.TestCmd> testCommands = testdata.getTestCommands();
            CommandExecutor.Result cmdResult = null;
            for (CLITestData.TestCmd cmd : testCommands) {
                try {
                    cmdResult = this.execute(cmd);
                }
                catch (Exception e) {
                    Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                }
            }
            boolean overallTCResult = true;
            ArrayList<ComparatorData> compdata = testdata.getComparatorData();
            for (ComparatorData cd : compdata) {
                String comptype = cd.getComparatorType();
                boolean compareOutput = false;
                if (!comptype.equalsIgnoreCase("none")) {
                    compareOutput = this.compareTestOutput(cd, cmdResult);
                    overallTCResult &= compareOutput;
                }
                cd.setExitCode(cmdResult.getExitCode());
                cd.setActualOutput(cmdResult.getCommandOutput());
                cd.setTestResult(compareOutput);
            }
            testdata.setTestResult(overallTCResult);
            ArrayList<CLITestData.TestCmd> cleanupCommands = testdata.getCleanupCommands();
            for (CLITestData.TestCmd cmd : cleanupCommands) {
                try {
                    this.execute(cmd);
                }
                catch (Exception e) {
                    Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    protected CommandExecutor.Result execute(CLITestData.TestCmd cmd) throws Exception {
        throw new Exception("Unknow type of Test command:" + (Object)((Object)cmd.getType()));
    }

    class TestConfigFileParser
    extends DefaultHandler {
        String charString = null;
        CLITestData td = null;
        ArrayList<CLITestData.TestCmd> testCommands = null;
        ArrayList<CLITestData.TestCmd> cleanupCommands = null;
        public static final String __PARANAMER_DATA = "characters char[],int,int ch,start,length \nendElement java.lang.String,java.lang.String,java.lang.String uri,localName,qName \nstartElement java.lang.String,java.lang.String,java.lang.String,org.xml.sax.Attributes uri,localName,qName,attributes \n";

        TestConfigFileParser() {
        }

        @Override
        public void startDocument() throws SAXException {
            CLITestHelper.this.testsFromConfigFile = new ArrayList();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(CLITestHelper.TESTMODE_TEST)) {
                this.td = new CLITestData();
            } else if (qName.equals("test-commands")) {
                this.testCommands = new ArrayList();
            } else if (qName.equals("cleanup-commands")) {
                this.cleanupCommands = new ArrayList();
            } else if (qName.equals("comparators")) {
                CLITestHelper.this.testComparators = new ArrayList();
            } else if (qName.equals("comparator")) {
                CLITestHelper.this.comparatorData = new ComparatorData();
            }
            this.charString = "";
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("description")) {
                this.td.setTestDesc(this.charString);
            } else if (qName.equals("test-commands")) {
                this.td.setTestCommands(this.testCommands);
                this.testCommands = null;
            } else if (qName.equals("cleanup-commands")) {
                this.td.setCleanupCommands(this.cleanupCommands);
                this.cleanupCommands = null;
            } else if (qName.equals("command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.FS));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.FS));
                }
            } else if (qName.equals("dfs-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.DFSADMIN));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.DFSADMIN));
                }
            } else if (qName.equals("mr-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.MRADMIN));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.MRADMIN));
                }
            } else if (qName.equals("archive-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.ARCHIVE));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.ARCHIVE));
                }
            } else if (qName.equals("comparators")) {
                this.td.setComparatorData(CLITestHelper.this.testComparators);
            } else if (qName.equals("comparator")) {
                CLITestHelper.this.testComparators.add(CLITestHelper.this.comparatorData);
            } else if (qName.equals("type")) {
                CLITestHelper.this.comparatorData.setComparatorType(this.charString);
            } else if (qName.equals("expected-output")) {
                CLITestHelper.this.comparatorData.setExpectedOutput(this.charString);
            } else if (qName.equals(CLITestHelper.TESTMODE_TEST)) {
                CLITestHelper.this.testsFromConfigFile.add(this.td);
                this.td = null;
            } else if (qName.equals("mode")) {
                CLITestHelper.this.testMode = this.charString;
                if (!CLITestHelper.this.testMode.equals(CLITestHelper.TESTMODE_NOCOMPARE) && !CLITestHelper.this.testMode.equals(CLITestHelper.TESTMODE_TEST)) {
                    CLITestHelper.this.testMode = CLITestHelper.TESTMODE_TEST;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            this.charString = this.charString + s;
        }
    }
}

