/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.crail.CrailBuffer;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageResult;
import org.apache.crail.storage.nvmf.client.NvmfStagingBufferCache;
import org.apache.crail.storage.nvmf.client.NvmfStorageEndpoint;

public class NvmfUnalignedWriteFuture
implements StorageFuture {
    private final NvmfStorageEndpoint endpoint;
    private StorageFuture beginFuture;
    private StorageFuture middleFuture;
    private StorageFuture endFuture;
    private final int written;
    private NvmfStagingBufferCache.BufferCacheEntry beginBuffer;
    private NvmfStagingBufferCache.BufferCacheEntry endBuffer;

    private final boolean isSectorAligned(long address) {
        return address % (long)this.endpoint.getLBADataSize() == 0L;
    }

    private final long floorToSectorSize(long address) {
        return address - (long)this.offsetInSector(address);
    }

    private final int floorToSectorSize(int length) {
        return length - this.offsetInSector(length);
    }

    private final int leftInSector(long address) {
        return this.endpoint.getLBADataSize() - this.offsetInSector(address);
    }

    private final int offsetInSector(long address) {
        return (int)(address % (long)this.endpoint.getLBADataSize());
    }

    NvmfUnalignedWriteFuture(NvmfStorageEndpoint endpoint, CrailBuffer buffer, BlockInfo blockInfo, long remoteOffset) throws Exception {
        this.endpoint = endpoint;
        this.written = buffer.remaining();
        assert (this.isSectorAligned(blockInfo.getAddr()));
        long nextRemoteOffset = remoteOffset;
        if (!this.isSectorAligned(remoteOffset)) {
            int copySize = Math.min(this.leftInSector(remoteOffset), buffer.remaining());
            nextRemoteOffset = remoteOffset + (long)copySize;
            int oldLimit = buffer.limit();
            buffer.limit(buffer.position() + copySize);
            long alignedRemoteOffset = this.floorToSectorSize(remoteOffset);
            long alignedRemoteAddress = blockInfo.getAddr() + alignedRemoteOffset;
            this.beginBuffer = endpoint.getStagingBufferCache().getExisting(alignedRemoteAddress);
            if (this.beginBuffer == null) {
                this.beginBuffer = endpoint.getStagingBufferCache().get(alignedRemoteAddress);
                endpoint.read(this.beginBuffer.getBuffer(), blockInfo, alignedRemoteOffset).get();
            } else {
                this.beginBuffer.getFuture().get();
            }
            CrailBuffer stagingBuffer = this.beginBuffer.getBuffer();
            stagingBuffer.position(this.offsetInSector(remoteOffset));
            stagingBuffer.getByteBuffer().put(buffer.getByteBuffer());
            buffer.limit(oldLimit);
            stagingBuffer.position(0);
            this.beginFuture = endpoint.write(stagingBuffer, blockInfo, alignedRemoteOffset);
            this.beginBuffer.setFuture(this.beginFuture);
            stagingBuffer.position(this.offsetInSector(remoteOffset));
        }
        if (this.isSectorAligned(nextRemoteOffset) && buffer.remaining() >= endpoint.getLBADataSize()) {
            int oldLimit = buffer.limit();
            buffer.limit(buffer.position() + this.floorToSectorSize(buffer.remaining()));
            int toWrite = buffer.remaining();
            this.middleFuture = endpoint.write(buffer, blockInfo, nextRemoteOffset);
            nextRemoteOffset += (long)toWrite;
            buffer.position(buffer.limit());
            buffer.limit(oldLimit);
        }
        if (buffer.remaining() > 0) {
            this.endBuffer = endpoint.getStagingBufferCache().get(blockInfo.getAddr() + nextRemoteOffset);
            CrailBuffer stagingBuffer = this.endBuffer.getBuffer();
            stagingBuffer.position(0);
            stagingBuffer.getByteBuffer().put(buffer.getByteBuffer());
            stagingBuffer.position(0);
            this.endFuture = endpoint.write(stagingBuffer, blockInfo, nextRemoteOffset);
            this.endBuffer.setFuture(this.endFuture);
        }
    }

    public boolean isSynchronous() {
        return false;
    }

    public boolean cancel(boolean b) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    private static boolean checkIfFutureIsDone(StorageFuture future) {
        return future != null && future.isDone() || future == null;
    }

    public boolean isDone() {
        if (this.beginFuture != null && this.beginFuture.isDone() && this.beginBuffer != null) {
            this.beginBuffer.put();
            this.beginBuffer = null;
        }
        if (this.endFuture != null && this.endFuture.isDone() && this.endBuffer != null) {
            this.endBuffer.put();
            this.endBuffer = null;
        }
        return this.beginBuffer == null && NvmfUnalignedWriteFuture.checkIfFutureIsDone(this.middleFuture) && this.endBuffer == null;
    }

    public StorageResult get() throws InterruptedException, ExecutionException {
        try {
            return this.get(2L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    public StorageResult get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.isDone()) {
            boolean waitTimeOut;
            long start = System.nanoTime();
            long end = start + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
            do {
                boolean bl = waitTimeOut = System.nanoTime() > end;
            } while (!this.isDone() && !waitTimeOut);
            if (!this.isDone() && waitTimeOut) {
                throw new TimeoutException("poll wait time out!");
            }
        }
        if (this.beginFuture != null) {
            this.beginFuture.get();
        }
        if (this.middleFuture != null) {
            this.middleFuture.get();
        }
        if (this.endFuture != null) {
            this.endFuture.get();
        }
        return () -> this.written;
    }
}

