/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf.client;

import com.ibm.jnvmf.Controller;
import com.ibm.jnvmf.IdentifyControllerData;
import com.ibm.jnvmf.IdentifyNamespaceData;
import com.ibm.jnvmf.IoQueuePair;
import com.ibm.jnvmf.KeyedSglDataBlockDescriptor;
import com.ibm.jnvmf.Namespace;
import com.ibm.jnvmf.NamespaceIdentifier;
import com.ibm.jnvmf.NvmIoCommandCapsule;
import com.ibm.jnvmf.NvmIoCommandSqe;
import com.ibm.jnvmf.NvmReadCommand;
import com.ibm.jnvmf.NvmReadCommandCapsule;
import com.ibm.jnvmf.NvmResponseCapsule;
import com.ibm.jnvmf.NvmWriteCommand;
import com.ibm.jnvmf.NvmWriteCommandCapsule;
import com.ibm.jnvmf.Nvme;
import com.ibm.jnvmf.NvmeQualifiedName;
import com.ibm.jnvmf.NvmfTransportId;
import com.ibm.jnvmf.QueuePair;
import com.ibm.jnvmf.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.nvmf.NvmfStorageConstants;
import org.apache.crail.storage.nvmf.client.NvmfFuture;
import org.apache.crail.storage.nvmf.client.NvmfRegisteredBufferCache;
import org.apache.crail.storage.nvmf.client.NvmfStagingBufferCache;
import org.apache.crail.storage.nvmf.client.NvmfUnalignedWriteFuture;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class NvmfStorageEndpoint
implements StorageEndpoint {
    private static final Logger LOG = CrailUtils.getLogger();
    private final Controller controller;
    private final IoQueuePair queuePair;
    private final int lbaDataSize;
    private final long namespaceCapacity;
    private final NvmfRegisteredBufferCache registeredBufferCache;
    private final NvmfStagingBufferCache stagingBufferCache;
    private final CrailStatistics statistics;
    private final Queue<NvmWriteCommand> writeCommands;
    private final Queue<NvmReadCommand> readCommands;
    private final AtomicInteger outstandingOperations;

    public NvmfStorageEndpoint(Nvme nvme, DataNodeInfo info, CrailStatistics statistics, CrailBufferCache bufferCache) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByAddress(info.getIpAddress()), info.getPort());
        NvmfTransportId transportId = new NvmfTransportId(inetSocketAddress, new NvmeQualifiedName(NvmfStorageConstants.NQN.toString()));
        LOG.info("Connecting to NVMf target at " + transportId.toString());
        this.controller = nvme.connect(transportId);
        this.controller.getControllerConfiguration().setEnable(true);
        this.controller.syncConfiguration();
        try {
            this.controller.waitUntilReady();
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
        IdentifyControllerData identifyControllerData = this.controller.getIdentifyControllerData();
        if (CrailConstants.SLICE_SIZE > identifyControllerData.getMaximumDataTransferSize().toInt()) {
            throw new IllegalArgumentException("crail.slicesize > max transfer size (" + identifyControllerData.getMaximumDataTransferSize() + ")");
        }
        List namespaces = this.controller.getActiveNamespaces();
        NamespaceIdentifier namespaceIdentifier = new NamespaceIdentifier(1);
        Namespace namespace = null;
        for (Namespace n : namespaces) {
            if (!n.getIdentifier().equals((Object)namespaceIdentifier)) continue;
            namespace = n;
            break;
        }
        if (namespace == null) {
            throw new IllegalArgumentException("No namespace with id " + namespaceIdentifier + " at controller " + transportId.toString());
        }
        IdentifyNamespaceData identifyNamespaceData = namespace.getIdentifyNamespaceData();
        this.lbaDataSize = identifyNamespaceData.getFormattedLbaSize().getLbaDataSize().toInt();
        if (CrailConstants.SLICE_SIZE % this.lbaDataSize != 0) {
            throw new IllegalArgumentException("crail.slicesize is not a multiple of LBA data size (" + this.lbaDataSize + ")");
        }
        this.namespaceCapacity = identifyNamespaceData.getNamespaceCapacity() * (long)this.lbaDataSize;
        this.queuePair = this.controller.createIoQueuePair(NvmfStorageConstants.QUEUE_SIZE, 0, 0, 64);
        this.writeCommands = new ArrayBlockingQueue<NvmWriteCommand>(NvmfStorageConstants.QUEUE_SIZE);
        this.readCommands = new ArrayBlockingQueue<NvmReadCommand>(NvmfStorageConstants.QUEUE_SIZE);
        for (int i = 0; i < NvmfStorageConstants.QUEUE_SIZE; ++i) {
            NvmWriteCommand writeCommand = new NvmWriteCommand(this.queuePair);
            writeCommand.setSendInline(true);
            ((NvmWriteCommandCapsule)writeCommand.getCommandCapsule()).getSubmissionQueueEntry().setNamespaceIdentifier(namespaceIdentifier);
            this.writeCommands.add(writeCommand);
            NvmReadCommand readCommand = new NvmReadCommand(this.queuePair);
            readCommand.setSendInline(true);
            ((NvmReadCommandCapsule)readCommand.getCommandCapsule()).getSubmissionQueueEntry().setNamespaceIdentifier(namespaceIdentifier);
            this.readCommands.add(readCommand);
        }
        this.registeredBufferCache = new NvmfRegisteredBufferCache((QueuePair)this.queuePair);
        this.outstandingOperations = new AtomicInteger(0);
        this.stagingBufferCache = new NvmfStagingBufferCache(bufferCache, NvmfStorageConstants.STAGING_CACHE_SIZE, this.getLBADataSize());
        this.statistics = statistics;
    }

    public void keepAlive() throws IOException {
        this.controller.keepAlive();
    }

    public int getLBADataSize() {
        return this.lbaDataSize;
    }

    public long getNamespaceCapacity() {
        return this.namespaceCapacity;
    }

    void putOperation() {
        this.outstandingOperations.decrementAndGet();
    }

    private boolean tryGetOperation() {
        int outstandingOperationsOld = this.outstandingOperations.get();
        if (outstandingOperationsOld < NvmfStorageConstants.QUEUE_SIZE) {
            return this.outstandingOperations.compareAndSet(outstandingOperationsOld, outstandingOperationsOld + 1);
        }
        return false;
    }

    private static int divCeil(int a, int b) {
        return (a + b - 1) / b;
    }

    private int getNumLogicalBlocks(CrailBuffer buffer) {
        return NvmfStorageEndpoint.divCeil(buffer.remaining(), this.getLBADataSize());
    }

    StorageFuture Op(Operation op, CrailBuffer buffer, BlockInfo blockInfo, long remoteOffset) throws InterruptedException, IOException {
        NvmReadCommand command;
        NvmfFuture<NvmReadCommand> future;
        Response response;
        assert (blockInfo.getAddr() + remoteOffset + (long)buffer.remaining() <= this.getNamespaceCapacity());
        assert (remoteOffset >= 0L);
        assert ((long)buffer.remaining() <= CrailConstants.BLOCK_SIZE);
        long startingAddress = blockInfo.getAddr() + remoteOffset;
        if (startingAddress % (long)this.getLBADataSize() != 0L || (startingAddress + (long)buffer.remaining()) % (long)this.getLBADataSize() != 0L && op == Operation.WRITE) {
            if (op == Operation.READ) {
                throw new IOException("Unaligned read access is not supported. Address (" + startingAddress + ") needs to be multiple of LBA data size " + this.getLBADataSize());
            }
            try {
                return new NvmfUnalignedWriteFuture(this, buffer, blockInfo, remoteOffset);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (!this.tryGetOperation()) {
            do {
                this.poll();
            } while (!this.tryGetOperation());
        }
        if (op == Operation.READ) {
            NvmReadCommand readCommand = this.readCommands.remove();
            response = readCommand.newResponse();
            future = new NvmfFuture<NvmReadCommand>(this, readCommand, (Response<NvmResponseCapsule>)response, this.readCommands, buffer.remaining());
            command = readCommand;
        } else {
            NvmWriteCommand writeCommand = this.writeCommands.remove();
            response = writeCommand.newResponse();
            future = new NvmfFuture<NvmWriteCommand>(this, writeCommand, (Response<NvmResponseCapsule>)response, this.writeCommands, buffer.remaining());
            command = writeCommand;
        }
        command.setCallback(future);
        response.setCallback(future);
        NvmIoCommandSqe sqe = (NvmIoCommandSqe)((NvmIoCommandCapsule)command.getCommandCapsule()).getSubmissionQueueEntry();
        long startingLBA = startingAddress / (long)this.getLBADataSize();
        sqe.setStartingLba(startingLBA);
        int numLogicalBlocks = this.getNumLogicalBlocks(buffer);
        buffer.limit(buffer.position() + numLogicalBlocks * this.getLBADataSize());
        sqe.setNumberOfLogicalBlocks(numLogicalBlocks);
        int remoteKey = this.registeredBufferCache.getRemoteKey(buffer);
        KeyedSglDataBlockDescriptor dataBlockDescriptor = sqe.getKeyedSglDataBlockDescriptor();
        dataBlockDescriptor.setAddress(buffer.address() + (long)buffer.position());
        dataBlockDescriptor.setLength(buffer.remaining());
        dataBlockDescriptor.setKey(remoteKey);
        command.execute(response);
        return future;
    }

    public StorageFuture write(CrailBuffer buffer, BlockInfo blockInfo, long remoteOffset) throws InterruptedException, IOException {
        return this.Op(Operation.WRITE, buffer, blockInfo, remoteOffset);
    }

    public StorageFuture read(CrailBuffer buffer, BlockInfo blockInfo, long remoteOffset) throws InterruptedException, IOException {
        return this.Op(Operation.READ, buffer, blockInfo, remoteOffset);
    }

    void poll() throws IOException {
        this.queuePair.poll();
    }

    public void close() throws IOException, InterruptedException {
        this.registeredBufferCache.free();
        this.controller.free();
    }

    public boolean isLocal() {
        return false;
    }

    NvmfStagingBufferCache getStagingBufferCache() {
        return this.stagingBufferCache;
    }

    static enum Operation {
        WRITE,
        READ;

    }
}

