/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf.client;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.storage.StorageFuture;

public class NvmfStagingBufferCache {
    private final Map<Long, BufferCacheEntry> remoteAddressMap;
    private final Queue<CrailBuffer> freeBuffers;
    private int buffersLeft;
    private final int lbaDataSize;
    private final CrailBufferCache bufferCache;

    private final CrailBufferCache getBufferCache() {
        return this.bufferCache;
    }

    NvmfStagingBufferCache(CrailBufferCache bufferCache, int maxEntries, int lbaDataSize) {
        if (maxEntries <= 0) {
            throw new IllegalArgumentException("maximum entries (" + maxEntries + ") <= 0");
        }
        if (lbaDataSize <= 0) {
            throw new IllegalArgumentException("LBA data size (" + lbaDataSize + ") <= 0");
        }
        this.remoteAddressMap = new ConcurrentHashMap<Long, BufferCacheEntry>(maxEntries);
        this.freeBuffers = new ArrayBlockingQueue<CrailBuffer>(maxEntries);
        this.buffersLeft = maxEntries;
        this.lbaDataSize = lbaDataSize;
        this.bufferCache = bufferCache;
    }

    synchronized void allocateFreeBuffers() throws Exception {
        if (!this.freeBuffers.isEmpty()) {
            return;
        }
        if (this.buffersLeft == 0) {
            Iterator<BufferCacheEntry> iterator = this.remoteAddressMap.values().iterator();
            while (iterator.hasNext()) {
                BufferCacheEntry currentEntry = iterator.next();
                if (!currentEntry.tryFree()) continue;
                iterator.remove();
                this.freeBuffers.add(currentEntry.getBuffer());
                return;
            }
            throw new OutOfMemoryError();
        }
        CrailBuffer buffer = this.getBufferCache().allocateBuffer();
        if (buffer == null) {
            throw new OutOfMemoryError();
        }
        if (buffer.capacity() < this.lbaDataSize) {
            throw new IllegalArgumentException("Slice size (" + buffer.capacity() + ") smaller LBA data size (" + this.lbaDataSize + ")");
        }
        int numStagingBuffers = buffer.remaining() / this.lbaDataSize;
        while (numStagingBuffers-- > 0 && this.buffersLeft > 0) {
            buffer.limit(buffer.position() + this.lbaDataSize);
            this.freeBuffers.add(buffer.slice());
            buffer.position(buffer.limit());
            --this.buffersLeft;
        }
    }

    BufferCacheEntry get(long alignedRemoteAddress) throws Exception {
        CrailBuffer buffer;
        do {
            if ((buffer = this.freeBuffers.poll()) != null) continue;
            this.allocateFreeBuffers();
        } while (buffer == null);
        buffer.clear();
        BufferCacheEntry entry = new BufferCacheEntry(buffer);
        BufferCacheEntry prevEntry = this.remoteAddressMap.putIfAbsent(alignedRemoteAddress, entry);
        if (prevEntry != null && prevEntry.tryFree()) {
            this.freeBuffers.add(prevEntry.getBuffer());
        }
        return entry;
    }

    BufferCacheEntry getExisting(long alignedRemoteAddress) {
        BufferCacheEntry entry = this.remoteAddressMap.get(alignedRemoteAddress);
        if (entry != null && !entry.tryGet()) {
            entry = null;
        }
        return entry;
    }

    static class BufferCacheEntry {
        private final CrailBuffer buffer;
        private final AtomicInteger pending;
        private StorageFuture future;

        BufferCacheEntry(CrailBuffer buffer) {
            this.buffer = buffer;
            this.pending = new AtomicInteger(1);
        }

        public StorageFuture getFuture() {
            return this.future;
        }

        public void setFuture(StorageFuture future) {
            this.future = future;
        }

        void put() {
            this.pending.decrementAndGet();
        }

        boolean tryGet() {
            int prevPending;
            do {
                if ((prevPending = this.pending.get()) >= 0) continue;
                return false;
            } while (!this.pending.compareAndSet(prevPending, prevPending + 1));
            return true;
        }

        boolean tryFree() {
            return this.pending.compareAndSet(0, -1);
        }

        CrailBuffer getBuffer() {
            return this.buffer;
        }
    }
}

