/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf.client;

import com.ibm.jnvmf.Freeable;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.QueuePair;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.CrailBuffer;

class NvmfRegisteredBufferCache
implements Freeable {
    private final QueuePair queuePair;
    private final Map<Long, KeyedNativeBuffer> regionMap;
    private boolean valid;

    public NvmfRegisteredBufferCache(QueuePair queuePair) {
        this.queuePair = queuePair;
        this.regionMap = new ConcurrentHashMap<Long, KeyedNativeBuffer>();
        this.valid = true;
    }

    int getRemoteKey(CrailBuffer buffer) throws IOException {
        KeyedNativeBuffer prevKeyedNativeBuffer;
        CrailBuffer regionBuffer = buffer.getRegion();
        KeyedNativeBuffer keyedNativeBuffer = this.regionMap.get(regionBuffer.address());
        if (keyedNativeBuffer == null && (prevKeyedNativeBuffer = this.regionMap.putIfAbsent((keyedNativeBuffer = this.queuePair.registerMemory(regionBuffer.getByteBuffer())).getAddress(), keyedNativeBuffer)) != null) {
            keyedNativeBuffer.free();
            keyedNativeBuffer = prevKeyedNativeBuffer;
        }
        return keyedNativeBuffer.getRemoteKey();
    }

    public void free() throws IOException {
        for (KeyedNativeBuffer buffer : this.regionMap.values()) {
            buffer.free();
        }
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }
}

