/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf.client;

import com.ibm.jnvmf.CompletionQueueEntry;
import com.ibm.jnvmf.GenericStatusCode;
import com.ibm.jnvmf.NvmCompletionQueueEntry;
import com.ibm.jnvmf.NvmIoCommand;
import com.ibm.jnvmf.NvmIoCommandCapsule;
import com.ibm.jnvmf.NvmResponseCapsule;
import com.ibm.jnvmf.OperationCallback;
import com.ibm.jnvmf.RdmaException;
import com.ibm.jnvmf.Response;
import com.ibm.jnvmf.StatusCode;
import com.ibm.jnvmf.UnsuccessfulComandException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageResult;
import org.apache.crail.storage.nvmf.client.NvmfStorageEndpoint;

public class NvmfFuture<Command extends NvmIoCommand<? extends NvmIoCommandCapsule>>
implements StorageFuture,
OperationCallback {
    private final NvmfStorageEndpoint endpoint;
    private final Command command;
    private final Queue<Command> operations;
    private volatile boolean done;
    private RdmaException exception;
    private final StorageResult storageResult;
    private final Response<NvmResponseCapsule> response;
    private final AtomicInteger completed;

    NvmfFuture(NvmfStorageEndpoint endpoint, Command command, Response<NvmResponseCapsule> response, Queue<Command> operations, int length) {
        this.endpoint = endpoint;
        this.command = command;
        this.operations = operations;
        this.done = false;
        this.storageResult = () -> length;
        this.response = response;
        this.completed = new AtomicInteger(0);
    }

    public boolean isSynchronous() {
        return false;
    }

    public boolean cancel(boolean b) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        if (!this.done) {
            try {
                this.endpoint.poll();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.done;
    }

    private final void checkStatus() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException((Throwable)this.exception);
        }
        NvmCompletionQueueEntry cqe = (NvmCompletionQueueEntry)((NvmResponseCapsule)this.response.getResponseCapsule()).getCompletionQueueEntry();
        StatusCode.Value statusCode = cqe.getStatusCode();
        if (statusCode != null && !statusCode.equals((Object)GenericStatusCode.getInstance().SUCCESS)) {
            throw new ExecutionException((Throwable)new UnsuccessfulComandException((CompletionQueueEntry)cqe));
        }
    }

    public StorageResult get() throws InterruptedException, ExecutionException {
        try {
            return this.get(2L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    public StorageResult get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            boolean waitTimeOut;
            long start = System.nanoTime();
            long end = start + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
            do {
                try {
                    this.endpoint.poll();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
                boolean bl = waitTimeOut = System.nanoTime() > end;
            } while (!this.done && !waitTimeOut);
            if (!this.done && waitTimeOut) {
                throw new TimeoutException("poll wait time out!");
            }
        }
        this.checkStatus();
        return this.storageResult;
    }

    public void onStart() {
    }

    public void onComplete() {
        assert (!this.done);
        assert (this.completed.get() < 2);
        if (this.completed.incrementAndGet() == 2) {
            this.operations.add(this.command);
            this.done = true;
            this.endpoint.putOperation();
        }
    }

    public void onFailure(RdmaException e) {
        assert (!this.done);
        this.operations.add(this.command);
        this.exception = e;
        this.done = true;
        this.endpoint.putOperation();
    }
}

