/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf;

import com.ibm.jnvmf.Controller;
import com.ibm.jnvmf.IdentifyNamespaceData;
import com.ibm.jnvmf.LbaFormat;
import com.ibm.jnvmf.Namespace;
import com.ibm.jnvmf.Nvme;
import com.ibm.jnvmf.NvmfTransportId;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.storage.StorageResource;
import org.apache.crail.storage.StorageServer;
import org.apache.crail.storage.nvmf.NvmfStorageConstants;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class NvmfStorageServer
implements StorageServer {
    private static final Logger LOG = CrailUtils.getLogger();
    private boolean isAlive;
    private long alignedSize;
    private long address;
    private boolean initialized = false;
    private Controller controller;

    public void init(CrailConfiguration crailConfiguration, String[] args) throws Exception {
        if (this.initialized) {
            throw new IOException("NvmfStorageTier already initialized");
        }
        this.initialized = true;
        NvmfStorageConstants.parseCmdLine(crailConfiguration, args);
        Nvme nvme = NvmfStorageConstants.HOST_NQN == null ? new Nvme() : new Nvme(NvmfStorageConstants.HOST_NQN);
        NvmfTransportId transportId = new NvmfTransportId(new InetSocketAddress(NvmfStorageConstants.IP_ADDR, NvmfStorageConstants.PORT), NvmfStorageConstants.NQN);
        this.controller = nvme.connect(transportId);
        this.controller.getControllerConfiguration().setEnable(true);
        this.controller.syncConfiguration();
        this.controller.waitUntilReady();
        List namespaces = this.controller.getActiveNamespaces();
        Namespace namespace = null;
        for (Namespace n : namespaces) {
            if (!n.getIdentifier().equals((Object)NvmfStorageConstants.NAMESPACE)) continue;
            namespace = n;
            break;
        }
        if (namespace == null) {
            throw new IllegalArgumentException("No namespace with id " + NvmfStorageConstants.NAMESPACE + " at controller " + transportId.toString());
        }
        IdentifyNamespaceData namespaceData = namespace.getIdentifyNamespaceData();
        LbaFormat lbaFormat = namespaceData.getFormattedLbaSize();
        int dataSize = lbaFormat.getLbaDataSize().toInt();
        long namespaceSize = (long)dataSize * namespaceData.getNamespaceCapacity();
        this.alignedSize = namespaceSize - namespaceSize % (long)NvmfStorageConstants.ALLOCATION_SIZE;
        this.address = 0L;
        this.isAlive = true;
    }

    public void printConf(Logger log) {
        NvmfStorageConstants.printConf(log);
    }

    public void run() {
        LOG.info("NnvmfStorageServer started with NVMf target " + this.getAddress());
        while (this.isAlive) {
            try {
                Thread.sleep(NvmfStorageConstants.KEEP_ALIVE_INTERVAL_MS);
                this.controller.keepAlive();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.isAlive = false;
            }
        }
    }

    public StorageResource allocateResource() throws Exception {
        StorageResource resource = null;
        if (this.alignedSize > 0L) {
            LOG.info("new block, length " + NvmfStorageConstants.ALLOCATION_SIZE);
            LOG.debug("block stag 0, address " + this.address + ", length " + NvmfStorageConstants.ALLOCATION_SIZE);
            this.alignedSize -= (long)NvmfStorageConstants.ALLOCATION_SIZE;
            resource = StorageResource.createResource((long)this.address, (int)NvmfStorageConstants.ALLOCATION_SIZE, (int)0);
            this.address += (long)NvmfStorageConstants.ALLOCATION_SIZE;
        }
        return resource;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(NvmfStorageConstants.IP_ADDR, NvmfStorageConstants.PORT);
    }

    public boolean isAlive() {
        return this.isAlive;
    }
}

