/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf;

import com.ibm.jnvmf.NamespaceIdentifier;
import com.ibm.jnvmf.NvmeQualifiedName;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.slf4j.Logger;

public class NvmfStorageConstants {
    private static final String PREFIX = "crail.storage.nvmf";
    public static final String IP_ADDR_KEY = "ip";
    public static InetAddress IP_ADDR;
    public static final String PORT_KEY = "port";
    public static int PORT;
    public static final String NQN_KEY = "nqn";
    public static NvmeQualifiedName NQN;
    public static final String HOST_NQN_KEY = "hostnqn";
    public static NvmeQualifiedName HOST_NQN;
    public static NamespaceIdentifier NAMESPACE;
    public static final String ALLOCATION_SIZE_KEY = "allocationsize";
    public static int ALLOCATION_SIZE;
    public static final String QUEUE_SIZE_KEY = "queueSize";
    public static int QUEUE_SIZE;
    public static final String STAGING_CACHE_SIZE_KEY = "stagingcachesize";
    public static int STAGING_CACHE_SIZE;
    public static long KEEP_ALIVE_INTERVAL_MS;

    private static String fullKey(String key) {
        return "crail.storage.nvmf." + key;
    }

    private static String get(CrailConfiguration conf, String key) {
        return conf.get(NvmfStorageConstants.fullKey(key));
    }

    public static void updateConstants(CrailConfiguration conf) throws UnknownHostException {
        String arg = NvmfStorageConstants.get(conf, IP_ADDR_KEY);
        if (arg != null) {
            IP_ADDR = InetAddress.getByName(arg);
        }
        if ((arg = NvmfStorageConstants.get(conf, PORT_KEY)) != null) {
            PORT = Integer.parseInt(arg);
        }
        if ((arg = NvmfStorageConstants.get(conf, NQN_KEY)) != null) {
            NQN = new NvmeQualifiedName(arg);
        }
        if ((arg = NvmfStorageConstants.get(conf, HOST_NQN_KEY)) != null) {
            HOST_NQN = new NvmeQualifiedName(arg);
        }
        if ((arg = NvmfStorageConstants.get(conf, ALLOCATION_SIZE_KEY)) != null) {
            ALLOCATION_SIZE = Integer.parseInt(arg);
        }
        if ((arg = NvmfStorageConstants.get(conf, QUEUE_SIZE_KEY)) != null) {
            QUEUE_SIZE = Integer.parseInt(arg);
        }
        if ((arg = NvmfStorageConstants.get(conf, STAGING_CACHE_SIZE_KEY)) != null) {
            STAGING_CACHE_SIZE = Integer.parseInt(arg);
        }
    }

    public static void verify() {
        if ((long)ALLOCATION_SIZE % CrailConstants.BLOCK_SIZE != 0L) {
            throw new IllegalArgumentException(NvmfStorageConstants.fullKey(ALLOCATION_SIZE_KEY) + " (" + ALLOCATION_SIZE + ") must be multiple of crail.blocksize (" + CrailConstants.BLOCK_SIZE + ")");
        }
        if (QUEUE_SIZE < 0) {
            throw new IllegalArgumentException("Queue size negative");
        }
    }

    public static void printConf(Logger logger) {
        if (IP_ADDR != null) {
            logger.info(NvmfStorageConstants.fullKey(IP_ADDR_KEY) + " " + IP_ADDR.getHostAddress());
        }
        logger.info(NvmfStorageConstants.fullKey(PORT_KEY) + " " + PORT);
        logger.info(NvmfStorageConstants.fullKey(NQN_KEY) + " " + NQN);
        logger.info(NvmfStorageConstants.fullKey(HOST_NQN_KEY) + " " + HOST_NQN);
        logger.info(NvmfStorageConstants.fullKey(ALLOCATION_SIZE_KEY) + " " + ALLOCATION_SIZE);
        logger.info(NvmfStorageConstants.fullKey(QUEUE_SIZE_KEY) + " " + QUEUE_SIZE);
    }

    public static void parseCmdLine(CrailConfiguration crailConfiguration, String[] args) throws IOException {
        NvmfStorageConstants.updateConstants(crailConfiguration);
        if (args != null) {
            Options options = new Options();
            Option bindIp = Option.builder((String)"a").desc("target ip address").hasArg().build();
            if (IP_ADDR == null) {
                bindIp.setRequired(true);
            }
            Option port = Option.builder((String)"p").desc("target port").hasArg().type(Number.class).build();
            Option namespace = Option.builder((String)"n").desc("namespace id").hasArg().type(Number.class).build();
            Option nqn = Option.builder((String)NQN_KEY).desc("target subsystem NQN").hasArg().build();
            Option hostnqn = Option.builder((String)HOST_NQN_KEY).desc("host NQN").hasArg().build();
            options.addOption(bindIp);
            options.addOption(port);
            options.addOption(nqn);
            options.addOption(hostnqn);
            options.addOption(namespace);
            DefaultParser parser = new DefaultParser();
            HelpFormatter formatter = new HelpFormatter();
            CommandLine line = null;
            try {
                line = parser.parse(options, args);
                if (line.hasOption(port.getOpt())) {
                    PORT = ((Number)line.getParsedOptionValue(port.getOpt())).intValue();
                }
                if (line.hasOption(namespace.getOpt())) {
                    NAMESPACE = new NamespaceIdentifier(((Number)line.getParsedOptionValue(namespace.getOpt())).intValue());
                }
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                formatter.printHelp("NVMe storage tier", options);
                System.exit(-1);
            }
            if (line.hasOption(bindIp.getOpt())) {
                IP_ADDR = InetAddress.getByName(line.getOptionValue(bindIp.getOpt()));
            }
            if (line.hasOption(nqn.getOpt())) {
                NQN = new NvmeQualifiedName(line.getOptionValue(nqn.getOpt()));
            }
            if (line.hasOption(hostnqn.getOpt())) {
                HOST_NQN = new NvmeQualifiedName(line.getOptionValue(hostnqn.getOpt()));
            }
        }
        NvmfStorageConstants.verify();
    }

    static {
        PORT = 50025;
        NQN = new NvmeQualifiedName("nqn.2017-06.io.crail:cnode");
        NAMESPACE = new NamespaceIdentifier(1);
        ALLOCATION_SIZE = 0x40000000;
        QUEUE_SIZE = 64;
        STAGING_CACHE_SIZE = 262144;
        KEEP_ALIVE_INTERVAL_MS = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    }
}

