/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf;

import com.ibm.jnvmf.Nvme;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageClient;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.nvmf.NvmfStorageConstants;
import org.apache.crail.storage.nvmf.client.NvmfStorageEndpoint;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class NvmfStorageClient
implements StorageClient {
    private static final Logger LOG = CrailUtils.getLogger();
    private static Nvme nvme;
    private boolean initialized = false;
    private volatile boolean closing = false;
    private final Thread keepAliveThread;
    private List<NvmfStorageEndpoint> endpoints = new CopyOnWriteArrayList<NvmfStorageEndpoint>();
    private CrailStatistics statistics;
    private CrailBufferCache bufferCache;

    public NvmfStorageClient() {
        this.keepAliveThread = new Thread(() -> {
            while (!this.closing) {
                for (NvmfStorageEndpoint endpoint : this.endpoints) {
                    try {
                        endpoint.keepAlive();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                try {
                    Thread.sleep(NvmfStorageConstants.KEEP_ALIVE_INTERVAL_MS);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        this.keepAliveThread.setDaemon(true);
    }

    boolean isAlive() {
        return this.keepAliveThread.isAlive();
    }

    public void init(CrailStatistics statistics, CrailBufferCache bufferCache, CrailConfiguration crailConfiguration, String[] args) throws IOException {
        if (this.initialized) {
            throw new IOException("NvmfStorageTier already initialized");
        }
        this.initialized = true;
        this.statistics = statistics;
        this.bufferCache = bufferCache;
        LOG.info("Initialize Nvmf storage client");
        NvmfStorageConstants.parseCmdLine(crailConfiguration, args);
        this.keepAliveThread.start();
    }

    public void printConf(Logger logger) {
        NvmfStorageConstants.printConf(logger);
    }

    private static Nvme getEndpointGroup() {
        if (nvme == null) {
            nvme = NvmfStorageConstants.HOST_NQN == null ? new Nvme() : new Nvme(NvmfStorageConstants.HOST_NQN);
        }
        return nvme;
    }

    public synchronized StorageEndpoint createEndpoint(DataNodeInfo info) throws IOException {
        if (!this.isAlive()) {
            throw new IOException("Storage client is not alive");
        }
        NvmfStorageEndpoint endpoint = new NvmfStorageEndpoint(NvmfStorageClient.getEndpointGroup(), info, this.statistics, this.bufferCache);
        this.endpoints.add(endpoint);
        return endpoint;
    }

    public void close() throws Exception {
        if (!this.closing) {
            this.closing = true;
            this.keepAliveThread.interrupt();
            this.keepAliveThread.join();
            for (StorageEndpoint storageEndpoint : this.endpoints) {
                storageEndpoint.close();
            }
        }
    }
}

