/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.darpc;

import com.ibm.darpc.DaRPCServerEndpoint;
import com.ibm.darpc.DaRPCServerEvent;
import com.ibm.darpc.DaRPCService;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeProtocol;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeRequest;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeResponse;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcNameNodeState;
import org.apache.crail.rpc.RpcProtocol;
import org.apache.crail.rpc.RpcRequestMessage;
import org.apache.crail.rpc.RpcResponseMessage;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DaRPCServiceDispatcher
extends DaRPCNameNodeProtocol
implements DaRPCService<DaRPCNameNodeRequest, DaRPCNameNodeResponse> {
    private static final Logger LOG = CrailUtils.getLogger();
    private RpcNameNodeService service;
    private AtomicLong totalOps;
    private AtomicLong createOps;
    private AtomicLong lookupOps;
    private AtomicLong setOps;
    private AtomicLong removeOps;
    private AtomicLong renameOps;
    private AtomicLong getOps;
    private AtomicLong locationOps;
    private AtomicLong errorOps;

    public DaRPCServiceDispatcher(RpcNameNodeService service) {
        this.service = service;
        this.totalOps = new AtomicLong(0L);
        this.createOps = new AtomicLong(0L);
        this.lookupOps = new AtomicLong(0L);
        this.setOps = new AtomicLong(0L);
        this.removeOps = new AtomicLong(0L);
        this.renameOps = new AtomicLong(0L);
        this.getOps = new AtomicLong(0L);
        this.locationOps = new AtomicLong(0L);
        this.errorOps = new AtomicLong(0L);
    }

    public void processServerEvent(DaRPCServerEvent<DaRPCNameNodeRequest, DaRPCNameNodeResponse> event) {
        DaRPCNameNodeRequest request = (DaRPCNameNodeRequest)event.getReceiveMessage();
        DaRPCNameNodeResponse response = (DaRPCNameNodeResponse)event.getSendMessage();
        short error = RpcErrors.ERR_OK;
        try {
            response.setType(RpcProtocol.responseTypes[request.getCmd()]);
            response.setError((short)0);
            switch (request.getCmd()) {
                case 1: {
                    this.totalOps.incrementAndGet();
                    this.createOps.incrementAndGet();
                    error = this.service.createFile(request.createFile(), response.createFile(), (RpcNameNodeState)response);
                    break;
                }
                case 2: {
                    this.totalOps.incrementAndGet();
                    this.lookupOps.incrementAndGet();
                    error = this.service.getFile(request.getFile(), response.getFile(), (RpcNameNodeState)response);
                    break;
                }
                case 3: {
                    this.totalOps.incrementAndGet();
                    this.setOps.incrementAndGet();
                    error = this.service.setFile(request.setFile(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 4: {
                    this.totalOps.incrementAndGet();
                    this.removeOps.incrementAndGet();
                    error = this.service.removeFile(request.removeFile(), response.delFile(), (RpcNameNodeState)response);
                    break;
                }
                case 5: {
                    this.totalOps.incrementAndGet();
                    this.renameOps.incrementAndGet();
                    error = this.service.renameFile(request.renameFile(), response.getRename(), (RpcNameNodeState)response);
                    break;
                }
                case 6: {
                    this.totalOps.incrementAndGet();
                    this.getOps.incrementAndGet();
                    error = this.service.getBlock(request.getBlock(), response.getBlock(), (RpcNameNodeState)response);
                    break;
                }
                case 7: {
                    this.totalOps.incrementAndGet();
                    this.locationOps.incrementAndGet();
                    error = this.service.getLocation(request.getLocation(), response.getLocation(), (RpcNameNodeState)response);
                    break;
                }
                case 8: {
                    error = this.service.setBlock(request.setBlock(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 12: {
                    error = this.service.getDataNode(request.getDataNode(), response.getDataNode(), (RpcNameNodeState)response);
                    break;
                }
                case 10: {
                    error = this.service.dump(request.dumpNameNode(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 11: {
                    error = this.stats(request.pingNameNode(), response.pingNameNode(), response);
                    error = this.service.ping(request.pingNameNode(), response.pingNameNode(), (RpcNameNodeState)response);
                    break;
                }
                default: {
                    error = RpcErrors.ERR_INVALID_RPC_CMD;
                    LOG.info("Rpc command not valid, opcode " + request.getCmd());
                    break;
                }
            }
        }
        catch (Exception e) {
            error = RpcErrors.ERR_UNKNOWN;
            this.errorOps.incrementAndGet();
            LOG.info(RpcErrors.messages[RpcErrors.ERR_UNKNOWN] + e.getMessage());
            e.printStackTrace();
        }
        try {
            response.setError(error);
            event.triggerResponse();
        }
        catch (Exception e) {
            LOG.info("ERROR: RPC failed, messagesSend ");
            e.printStackTrace();
        }
    }

    public short stats(RpcRequestMessage.PingNameNodeReq request, RpcResponseMessage.PingNameNodeRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)11, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        LOG.info("totalOps " + this.totalOps.get());
        LOG.info("errorOps " + this.errorOps.get());
        LOG.info("createOps " + this.createOps.get());
        LOG.info("lookupOps " + this.lookupOps.get());
        LOG.info("setOps " + this.setOps.get());
        LOG.info("removeOps " + this.removeOps.get());
        LOG.info("renameOps " + this.renameOps.get());
        LOG.info("getOps " + this.getOps.get());
        LOG.info("locationOps " + this.locationOps.get());
        return RpcErrors.ERR_OK;
    }

    public void open(DaRPCServerEndpoint<DaRPCNameNodeRequest, DaRPCNameNodeResponse> endpoint) {
        try {
            LOG.info("RPC connection, qpnum " + endpoint.getQp().getQp_num());
        }
        catch (IOException e) {
            LOG.info("RPC connection, cannot get qpnum, because QP is not open.\n");
        }
    }

    public void close(DaRPCServerEndpoint<DaRPCNameNodeRequest, DaRPCNameNodeResponse> endpoint) {
        try {
            LOG.info("disconnecting RPC connection, qpnum " + endpoint.getQp().getQp_num());
            endpoint.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

