/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.darpc;

import com.ibm.darpc.DaRPCServerEndpoint;
import com.ibm.darpc.DaRPCServerGroup;
import com.ibm.darpc.DaRPCService;
import com.ibm.disni.RdmaServerEndpoint;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.namenode.rpc.darpc.DaRPCConstants;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeRequest;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeResponse;
import org.apache.crail.namenode.rpc.darpc.DaRPCServiceDispatcher;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcServer;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DaRPCNameNodeServer
extends RpcServer {
    private static final Logger LOG = CrailUtils.getLogger();
    private RpcNameNodeService service;
    private DaRPCServerGroup<DaRPCNameNodeRequest, DaRPCNameNodeResponse> namenodeServerGroup;
    private RdmaServerEndpoint<DaRPCServerEndpoint<DaRPCNameNodeRequest, DaRPCNameNodeResponse>> namenodeServerEp;

    public DaRPCNameNodeServer(RpcNameNodeService service) {
        this.service = service;
        this.namenodeServerEp = null;
        this.namenodeServerGroup = null;
    }

    public void init(CrailConfiguration conf, String[] args) throws Exception {
        DaRPCConstants.updateConstants(conf);
        DaRPCConstants.verify();
        String[] _clusterAffinities = DaRPCConstants.NAMENODE_DARPC_AFFINITY.split(",");
        long[] clusterAffinities = new long[_clusterAffinities.length];
        for (int i = 0; i < clusterAffinities.length; ++i) {
            int affinity = Integer.decode(_clusterAffinities[i]);
            clusterAffinities[i] = 1L << affinity;
        }
        DaRPCServiceDispatcher darpcService = new DaRPCServiceDispatcher(this.service);
        this.namenodeServerGroup = DaRPCServerGroup.createServerGroup((DaRPCService)darpcService, (long[])clusterAffinities, (int)-1, (int)DaRPCConstants.NAMENODE_DARPC_MAXINLINE, (boolean)DaRPCConstants.NAMENODE_DARPC_POLLING, (int)DaRPCConstants.NAMENODE_DARPC_RECVQUEUE, (int)DaRPCConstants.NAMENODE_DARPC_SENDQUEUE, (int)DaRPCConstants.NAMENODE_DARPC_POLLSIZE, (int)DaRPCConstants.NAMENODE_DARPC_CLUSTERSIZE);
        LOG.info("rpc group started, recvQueue " + this.namenodeServerGroup.recvQueueSize());
        this.namenodeServerEp = this.namenodeServerGroup.createServerEndpoint();
    }

    public void printConf(Logger logger) {
        DaRPCConstants.printConf(logger);
    }

    public void run() {
        try {
            InetSocketAddress addr = CrailUtils.getNameNodeAddress();
            this.namenodeServerEp.bind((SocketAddress)addr, DaRPCConstants.NAMENODE_DARPC_BACKLOG);
            LOG.info("opened server at " + addr);
            while (true) {
                DaRPCServerEndpoint clientEndpoint = (DaRPCServerEndpoint)this.namenodeServerEp.accept();
                LOG.info("accepting RPC connection, qpnum " + clientEndpoint.getQp().getQp_num());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
            return;
        }
    }
}

