/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.reduce.InMemoryMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.OnDiskMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornShuffleFetcher<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CelebornShuffleFetcher.class);
    private final TaskAttemptID reduceId;
    private final Reporter reporter;
    private final TaskStatus status;
    private final MergeManager<K, V> merger;
    private final Progress progress;
    private final ShuffleClientMetrics metrics;
    private final CelebornInputStream celebornInputStream;
    private volatile boolean stopped = false;
    private int uniqueMapId = 0;
    private final Counters.Counter ioErrs;
    private boolean hasPendingData = false;
    private long inputShuffleSize;
    private byte[] shuffleData;

    public CelebornShuffleFetcher(TaskAttemptID reduceId, TaskStatus status, MergeManager<K, V> merger, Progress progress, Reporter reporter, ShuffleClientMetrics metrics, CelebornInputStream input) {
        this.reduceId = reduceId;
        this.reporter = reporter;
        this.status = status;
        this.merger = merger;
        this.progress = progress;
        this.metrics = metrics;
        this.celebornInputStream = input;
        this.ioErrs = reporter.getCounter("Shuffle Errors", "IO_ERROR");
    }

    public void fetchAndMerge() {
        while (!this.stopped) {
            try {
                this.merger.waitForResource();
                this.metrics.threadBusy();
                this.fetchToLocalAndMerge();
            }
            catch (Exception e) {
                logger.error("Celeborn shuffle fetcher fetch data failed.", (Throwable)e);
            }
            finally {
                this.metrics.threadFree();
            }
        }
    }

    private byte[] getShuffleBlock() throws IOException {
        byte[] header = new byte[4];
        int count = this.celebornInputStream.read(header);
        if (count == -1) {
            this.stopped = true;
            return null;
        }
        while (count != header.length) {
            count += this.celebornInputStream.read(header, count, 4 - count);
        }
        int blockLen = Platform.getInt(header, Platform.BYTE_ARRAY_OFFSET);
        this.inputShuffleSize += (long)blockLen;
        byte[] shuffleData = new byte[blockLen];
        count = this.celebornInputStream.read(shuffleData);
        while (count != shuffleData.length) {
            if ((count += this.celebornInputStream.read(shuffleData, count, blockLen - count)) != -1) continue;
            this.stopped = true;
            throw new CelebornIOException("Read mr shuffle failed.");
        }
        return shuffleData;
    }

    private void fetchToLocalAndMerge() throws IOException {
        if (!this.hasPendingData) {
            this.shuffleData = this.getShuffleBlock();
        }
        if (this.shuffleData != null) {
            if (!this.wrapMapOutput(this.shuffleData)) {
                return;
            }
            this.hasPendingData = false;
            this.updateStatus();
            this.reporter.progress();
        } else {
            this.celebornInputStream.close();
            this.metrics.inputBytes(this.inputShuffleSize);
            logger.info("reduce task {} read {} bytes", (Object)this.reduceId, (Object)this.inputShuffleSize);
            this.stopped = true;
        }
    }

    private boolean wrapMapOutput(byte[] shuffleData) throws IOException {
        TaskAttemptID mapId = new TaskAttemptID(new TaskID(this.reduceId.getJobID(), TaskType.MAP, this.uniqueMapId++), 0);
        MapOutput mapOutput = null;
        try {
            mapOutput = this.merger.reserve(mapId, (long)shuffleData.length, 0);
        }
        catch (IOException ioe) {
            this.ioErrs.increment(1L);
            throw ioe;
        }
        if (mapOutput == null) {
            logger.info("Celeborn fetcher returned status wait because reserve buffer for shuffle get null");
            this.hasPendingData = true;
            return false;
        }
        try {
            this.writeShuffle(mapOutput, shuffleData);
            mapOutput.commit();
        }
        catch (Throwable t) {
            this.ioErrs.increment(1L);
            mapOutput.abort();
            throw new CelebornIOException("Reduce: {} " + this.reduceId + " fetch failed to {} " + mapOutput.getClass().getSimpleName() + " due to: {} " + t.getClass().getName());
        }
        return true;
    }

    private Decompressor getDecompressor(InMemoryMapOutput inMemoryMapOutput) throws CelebornIOException {
        try {
            Class<?> clazz = Class.forName(InMemoryMapOutput.class.getName());
            Field deCompressorField = clazz.getDeclaredField("decompressor");
            deCompressorField.setAccessible(true);
            return (Decompressor)deCompressorField.get(inMemoryMapOutput);
        }
        catch (Exception e) {
            throw new CelebornIOException("Get Decompressor fail " + e.getMessage());
        }
    }

    private void writeShuffle(MapOutput mapOutput, byte[] shuffle) throws CelebornIOException {
        if (!(mapOutput instanceof InMemoryMapOutput)) {
            if (mapOutput instanceof OnDiskMapOutput) {
                throw new IllegalStateException("Celeborn map reduce client do not support OnDiskMapOutput. Try to increase mapreduce.reduce.shuffle.memory.limit.percent");
            }
            throw new IllegalStateException("Merger reserve unknown type of MapOutput: " + mapOutput.getClass().getCanonicalName());
        }
        InMemoryMapOutput inMemoryMapOutput = (InMemoryMapOutput)mapOutput;
        CodecPool.returnDecompressor((Decompressor)this.getDecompressor(inMemoryMapOutput));
        byte[] memory = inMemoryMapOutput.getMemory();
        System.arraycopy(shuffle, 0, memory, 0, shuffle.length);
    }

    private void updateStatus() {
        this.progress.set((float)this.celebornInputStream.partitionsRead() / (float)this.celebornInputStream.totalPartitionsToRead());
        String statusString = this.celebornInputStream.partitionsRead() + " / " + this.celebornInputStream.totalPartitionsToRead() + " copied.";
        this.status.setStateString(statusString);
        this.progress.setStatus("copy(" + this.celebornInputStream.partitionsRead() + " of " + this.celebornInputStream.totalPartitionsToRead());
    }
}

