/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.celeborn.common.network.util.ByteUnit;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import org.apache.celeborn.shaded.com.google.common.collect.ImmutableMap;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.org.apache.commons.lang3.JavaVersion;
import org.apache.celeborn.shaded.org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtils {
    private static final Logger logger = LoggerFactory.getLogger(JavaUtils.class);
    private static final ImmutableMap<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put("us", TimeUnit.MICROSECONDS).put("ms", TimeUnit.MILLISECONDS).put("s", TimeUnit.SECONDS).put("m", TimeUnit.MINUTES).put("min", TimeUnit.MINUTES).put("h", TimeUnit.HOURS).put("d", TimeUnit.DAYS).build();
    private static final ImmutableMap<String, ByteUnit> byteSuffixes = ImmutableMap.builder().put("b", ByteUnit.BYTE).put("k", ByteUnit.KiB).put("kb", ByteUnit.KiB).put("kib", ByteUnit.KiB).put("ki", ByteUnit.KiB).put("m", ByteUnit.MiB).put("mb", ByteUnit.MiB).put("mib", ByteUnit.MiB).put("mi", ByteUnit.MiB).put("g", ByteUnit.GiB).put("gb", ByteUnit.GiB).put("gib", ByteUnit.GiB).put("gi", ByteUnit.GiB).put("t", ByteUnit.TiB).put("tb", ByteUnit.TiB).put("tib", ByteUnit.TiB).put("ti", ByteUnit.TiB).put("p", ByteUnit.PiB).put("pb", ByteUnit.PiB).put("pib", ByteUnit.PiB).put("pi", ByteUnit.PiB).build();

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.error("IOException should not have been thrown.", (Throwable)e);
        }
    }

    public static int nonNegativeHash(Object obj) {
        if (obj == null) {
            return 0;
        }
        int hash = obj.hashCode();
        return hash != Integer.MIN_VALUE ? Math.abs(hash) : 0;
    }

    public static ByteBuffer stringToBytes(String s) {
        return Unpooled.wrappedBuffer(s.getBytes(StandardCharsets.UTF_8)).nioBuffer();
    }

    public static String bytesToString(ByteBuffer b) {
        return Unpooled.wrappedBuffer(b).toString(StandardCharsets.UTF_8);
    }

    public static void deleteRecursively(File file) throws IOException {
        JavaUtils.deleteRecursively(file, null);
    }

    public static void deleteRecursively(File file, FilenameFilter filter) throws IOException {
        if (file == null) {
            return;
        }
        if (SystemUtils.IS_OS_UNIX && filter == null) {
            try {
                JavaUtils.deleteRecursivelyUsingUnixNative(file);
                return;
            }
            catch (IOException e) {
                logger.warn("Attempt to delete using native Unix OS command failed for path = {}. Falling back to Java IO way", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        JavaUtils.deleteRecursivelyUsingJavaIO(file, filter);
    }

    private static void deleteRecursivelyUsingJavaIO(File file, FilenameFilter filter) throws IOException {
        boolean deleted;
        if (file.isDirectory() && !JavaUtils.isSymlink(file)) {
            IOException savedIOException = null;
            for (File child : JavaUtils.listFilesSafely(file, filter)) {
                try {
                    JavaUtils.deleteRecursively(child, filter);
                }
                catch (IOException e) {
                    savedIOException = e;
                }
            }
            if (savedIOException != null) {
                throw savedIOException;
            }
        }
        if ((file.isFile() || file.isDirectory() && JavaUtils.listFilesSafely(file, null).length == 0) && !(deleted = file.delete()) && file.exists()) {
            throw new IOException("Failed to delete: " + file.getAbsolutePath());
        }
    }

    private static void deleteRecursivelyUsingUnixNative(File file) throws IOException {
        ProcessBuilder builder = new ProcessBuilder("rm", "-rf", file.getAbsolutePath());
        Process process = null;
        int exitCode = -1;
        try {
            builder.redirectErrorStream(true);
            builder.redirectOutput(new File("/dev/null"));
            process = builder.start();
            exitCode = process.waitFor();
        }
        catch (Exception e) {
            throw new IOException("Failed to delete: " + file.getAbsolutePath(), e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        if (exitCode != 0 || file.exists()) {
            throw new IOException("Failed to delete: " + file.getAbsolutePath());
        }
    }

    private static File[] listFilesSafely(File file, FilenameFilter filter) throws IOException {
        if (file.exists()) {
            File[] files = file.listFiles(filter);
            if (files == null) {
                throw new IOException("Failed to list files for dir: " + file);
            }
            return files;
        }
        return new File[0];
    }

    private static boolean isSymlink(File file) throws IOException {
        Preconditions.checkNotNull(file);
        File fileInCanonicalDir = null;
        fileInCanonicalDir = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m.group(1));
            String suffix = m.group(2);
            if (suffix != null && !timeSuffixes.containsKey(suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, suffix != null ? timeSuffixes.get(suffix) : unit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }

    public static long timeStringAsMs(String str) {
        return JavaUtils.timeStringAs(str, TimeUnit.MILLISECONDS);
    }

    public static long timeStringAsSec(String str) {
        return JavaUtils.timeStringAs(str, TimeUnit.SECONDS);
    }

    public static long byteStringAs(String str, ByteUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
            Matcher fractionMatcher = Pattern.compile("([0-9]+\\.[0-9]+)([a-z]+)?").matcher(lower);
            if (m.matches()) {
                long val = Long.parseLong(m.group(1));
                String suffix = m.group(2);
                if (suffix != null && !byteSuffixes.containsKey(suffix)) {
                    throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
                }
                return unit.convertFrom(val, suffix != null ? byteSuffixes.get(suffix) : unit);
            }
            if (fractionMatcher.matches()) {
                throw new NumberFormatException("Fractional values are not supported. Input was: " + fractionMatcher.group(1));
            }
            throw new NumberFormatException("Failed to parse byte string: " + str);
        }
        catch (NumberFormatException e) {
            String byteError = "Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new NumberFormatException(byteError + "\n" + e.getMessage());
        }
    }

    public static long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.BYTE);
    }

    public static long byteStringAsKb(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.KiB);
    }

    public static long byteStringAsMb(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.MiB);
    }

    public static long byteStringAsGb(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.GiB);
    }

    public static byte[] bufferToArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.remaining()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer dst) throws IOException {
        int expected = dst.remaining();
        while (dst.hasRemaining()) {
            if (channel.read(dst) >= 0) continue;
            throw new EOFException(String.format("Not enough bytes in channel (expected %d).", expected));
        }
    }

    public static String mkString(String[] arr, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
            if (i == arr.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static void randomizeInPlace(int[] arr) {
        Random rand = new Random();
        for (int i = arr.length - 1; i >= 1; --i) {
            int j = rand.nextInt(i + 1);
            int tmp = arr[j];
            arr[j] = arr[i];
            arr[i] = tmp;
        }
    }

    public static void shuffleArray(int[] arr, int[] inversed) {
        int i;
        if (arr == null || inversed == null || arr.length != inversed.length) {
            return;
        }
        for (i = 0; i < arr.length; ++i) {
            arr[i] = i;
        }
        JavaUtils.randomizeInPlace(arr);
        for (i = 0; i < arr.length; ++i) {
            inversed[arr[i]] = i;
        }
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        if (SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_9)) {
            return new ConcurrentHashMap();
        }
        return new ConcurrentHashMapForJDK8();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> m) {
        if (SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_9)) {
            return new ConcurrentHashMap<K, V>(m);
        }
        return new ConcurrentHashMapForJDK8<K, V>(m);
    }

    public static void timeOutOrMeetCondition(Callable<Boolean> callable) throws Exception {
        for (int timeout = 10000; !callable.call().booleanValue() && timeout >= 0; timeout -= 100) {
            Thread.sleep(100L);
        }
    }

    public static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ConcurrentHashMapForJDK8<K, V>
    extends ConcurrentHashMap<K, V> {
        public ConcurrentHashMapForJDK8() {
        }

        public ConcurrentHashMapForJDK8(Map<? extends K, ? extends V> m) {
            super(m);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Object result = this.get(key);
            if (null == result) {
                result = super.computeIfAbsent(key, mappingFunction);
            }
            return result;
        }
    }
}

