/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.LinkedList;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.util.FrameDecoder;

public class TransportFrameDecoder
extends ChannelInboundHandlerAdapter
implements FrameDecoder {
    private int msgSize = -1;
    private int bodySize = -1;
    private Message.Type curType = Message.Type.UNKNOWN_TYPE;
    private ByteBuf headerBuf = Unpooled.buffer((int)9, (int)9);
    private static final int MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int UNKNOWN_FRAME_SIZE = -1;
    private final LinkedList<ByteBuf> buffers = new LinkedList();
    private long totalSize = 0L;
    private long nextFrameSize = -1L;

    public void channelRead(ChannelHandlerContext ctx, Object data) {
        ByteBuf frame;
        ByteBuf in = (ByteBuf)data;
        this.buffers.add(in);
        this.totalSize += (long)in.readableBytes();
        while (!this.buffers.isEmpty() && (frame = this.decodeNext()) != null) {
            Message msg = Message.decode(this.curType, frame);
            if (msg.body() == null) {
                frame.release();
            }
            ctx.fireChannelRead((Object)msg);
            this.clear();
        }
    }

    private void clear() {
        this.curType = Message.Type.UNKNOWN_TYPE;
        this.msgSize = -1;
        this.bodySize = -1;
        this.headerBuf.clear();
    }

    private long decodeFrameSize() {
        if (this.nextFrameSize != -1L || this.totalSize < 9L) {
            return this.nextFrameSize;
        }
        ByteBuf first = this.buffers.getFirst();
        if (first.readableBytes() >= 9) {
            this.msgSize = first.readInt();
            this.curType = Message.Type.decode(first);
            this.bodySize = first.readInt();
            this.nextFrameSize = (long)this.msgSize + (long)this.bodySize;
            this.totalSize -= 9L;
            if (!first.isReadable()) {
                this.buffers.removeFirst().release();
            }
            return this.nextFrameSize;
        }
        while (this.headerBuf.readableBytes() < 9) {
            ByteBuf next = this.buffers.getFirst();
            int toRead = Math.min(next.readableBytes(), 9 - this.headerBuf.readableBytes());
            this.headerBuf.writeBytes(next, toRead);
            if (next.isReadable()) continue;
            this.buffers.removeFirst().release();
        }
        this.msgSize = this.headerBuf.readInt();
        this.curType = Message.Type.decode(this.headerBuf);
        this.bodySize = this.headerBuf.readInt();
        this.nextFrameSize = (long)this.msgSize + (long)this.bodySize;
        this.totalSize -= 9L;
        return this.nextFrameSize;
    }

    private ByteBuf decodeNext() {
        ByteBuf next;
        int remaining;
        long frameSize = this.decodeFrameSize();
        if (frameSize == -1L || this.totalSize < frameSize) {
            return null;
        }
        this.nextFrameSize = -1L;
        Preconditions.checkArgument((frameSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Too large frame: %s", (long)frameSize);
        Preconditions.checkArgument((frameSize > 0L ? 1 : 0) != 0, (String)"Frame length should be positive: %s", (long)frameSize);
        if (this.buffers.getFirst().readableBytes() >= remaining) {
            return this.nextBufferForFrame(remaining);
        }
        CompositeByteBuf frame = this.buffers.getFirst().alloc().compositeBuffer(Integer.MAX_VALUE);
        for (remaining = (int)frameSize; remaining > 0; remaining -= next.readableBytes()) {
            next = this.nextBufferForFrame(remaining);
            frame.addComponent(next).writerIndex(frame.writerIndex() + next.readableBytes());
        }
        assert (remaining == 0);
        return frame;
    }

    private ByteBuf nextBufferForFrame(int bytesToRead) {
        ByteBuf frame;
        ByteBuf buf = this.buffers.getFirst();
        if (buf.readableBytes() > bytesToRead) {
            frame = buf.retain().readSlice(bytesToRead);
            this.totalSize -= (long)bytesToRead;
        } else {
            frame = buf;
            this.buffers.removeFirst();
            this.totalSize -= (long)frame.readableBytes();
        }
        return frame;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        for (ByteBuf b : this.buffers) {
            b.release();
        }
        this.buffers.clear();
        this.headerBuf.release();
        super.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }
}

