/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.client;

import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.client.MasterNotLeaderException;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.protocol.message.ControlMessages$OneWayMessageResponse$;
import org.apache.celeborn.common.protocol.message.MasterRequestMessage;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;

public class MasterClient {
    private static final Logger LOG = LoggerFactory.getLogger(MasterClient.class);
    private final RpcEnv rpcEnv;
    private final List<String> masterEndpoints;
    private final int maxRetries;
    private final RpcTimeout rpcTimeout;
    private final AtomicReference<RpcEndpointRef> rpcEndpointRef;
    private final ExecutorService oneWayMessageSender;
    private static final String SPLITTER = "#";
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();

    public MasterClient(RpcEnv rpcEnv, CelebornConf conf) {
        this.rpcEnv = rpcEnv;
        this.masterEndpoints = Arrays.asList(conf.masterEndpoints());
        Collections.shuffle(this.masterEndpoints);
        this.maxRetries = Math.max(this.masterEndpoints.size(), conf.masterClientMaxRetries());
        this.rpcTimeout = conf.masterClientRpcAskTimeout();
        this.rpcEndpointRef = new AtomicReference();
        this.oneWayMessageSender = ThreadUtils.newDaemonSingleThreadExecutor("celeborn-one-way-message-sender");
    }

    static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    public static Tuple2<String, Long> decodeRequestId(String requestId) {
        if (requestId.contains(SPLITTER)) {
            return new Tuple2((Object)requestId.split(SPLITTER)[0], (Object)Long.valueOf(requestId.split(SPLITTER)[1]));
        }
        return null;
    }

    public static String encodeRequestId(String uuid, long callId) {
        return String.format("%s%s%d", uuid, SPLITTER, callId);
    }

    public static String genRequestId() {
        return MasterClient.encodeRequestId(UUID.randomUUID().toString(), MasterClient.nextCallId());
    }

    public void send(Message message) throws Throwable {
        this.oneWayMessageSender.submit(() -> {
            try {
                this.sendMessageInner(message, ControlMessages$OneWayMessageResponse$.class);
            }
            catch (Throwable e) {
                LOG.warn("Exception occurs while send one-way message.", e);
            }
        });
        LOG.debug("Send one-way message {}.", (Object)message);
    }

    public <T> T askSync(Message message, Class<T> clz) throws Throwable {
        return this.sendMessageInner(message, clz);
    }

    public <T> T askSync(GeneratedMessageV3 message, Class<T> clz) throws Throwable {
        return this.sendMessageInner(message, clz);
    }

    public void close() {
        ThreadUtils.shutdown(this.oneWayMessageSender, Duration.apply((String)"800ms"));
    }

    private <T> T sendMessageInner(Object message, Class<T> clz) throws Throwable {
        Throwable throwable = null;
        int numTries = 0;
        boolean shouldRetry = true;
        if (message instanceof MasterRequestMessage) {
            ((MasterRequestMessage)message).requestId_(MasterClient.encodeRequestId(UUID.randomUUID().toString(), MasterClient.nextCallId()));
        }
        LOG.debug("Send rpc message {}", message);
        RpcEndpointRef endpointRef = null;
        AtomicInteger currentMasterIdx = new AtomicInteger(0);
        long sleepLimitTime = 2000L;
        while (numTries < this.maxRetries && shouldRetry) {
            try {
                endpointRef = this.getOrSetupRpcEndpointRef(currentMasterIdx);
                Future future = endpointRef.ask(message, this.rpcTimeout, ClassTag$.MODULE$.apply(clz));
                return this.rpcTimeout.awaitResult(future);
            }
            catch (Throwable e) {
                throwable = e;
                shouldRetry = this.shouldRetry(endpointRef, throwable);
                if (!shouldRetry) continue;
                Uninterruptibles.sleepUninterruptibly((long)Math.min((long)(++numTries) * 100L, sleepLimitTime), (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        LOG.error("Send rpc with failure, has tried {}, max try {}!", new Object[]{numTries, this.maxRetries, throwable});
        throw throwable;
    }

    private boolean shouldRetry(@Nullable RpcEndpointRef oldRef, Throwable e) {
        if (e.getCause() instanceof MasterNotLeaderException) {
            MasterNotLeaderException exception = (MasterNotLeaderException)e.getCause();
            String leaderAddr = exception.getSuggestedLeaderAddress();
            if (!leaderAddr.equals("leader is not present")) {
                this.setRpcEndpointRef(leaderAddr);
            } else {
                LOG.warn("Master leader is not present currently, please check masters' status!");
            }
            return true;
        }
        if (e.getCause() instanceof IOException) {
            this.resetRpcEndpointRef(oldRef);
            return true;
        }
        return false;
    }

    private void setRpcEndpointRef(String masterEndpoint) {
        this.rpcEndpointRef.set(this.setupEndpointRef(masterEndpoint));
        LOG.info("Fail over to master {}.", (Object)masterEndpoint);
    }

    private void resetRpcEndpointRef(@Nullable RpcEndpointRef oldRef) {
        if (this.rpcEndpointRef.compareAndSet(oldRef, null)) {
            LOG.debug("Reset the connection to master {}.", oldRef != null ? oldRef.address() : "null");
        }
    }

    private RpcEndpointRef getOrSetupRpcEndpointRef(AtomicInteger currentIndex) {
        RpcEndpointRef endpointRef = this.rpcEndpointRef.get();
        if (endpointRef == null) {
            int index = currentIndex.get();
            do {
                RpcEndpointRef tempEndpointRef;
                if (!this.rpcEndpointRef.compareAndSet(null, tempEndpointRef = this.setupEndpointRef(this.masterEndpoints.get(index)))) continue;
                index = (index + 1) % this.masterEndpoints.size();
            } while ((endpointRef = this.rpcEndpointRef.get()) == null && index != currentIndex.get());
            currentIndex.set(index);
            if (endpointRef == null) {
                throw new IllegalStateException("After trying all the available Master Addresses, an usable link still couldn't be created.");
            }
            LOG.info("connect to master {}.", (Object)endpointRef.address());
        }
        return endpointRef;
    }

    private RpcEndpointRef setupEndpointRef(String endpoint) {
        RpcEndpointRef endpointRef = null;
        try {
            endpointRef = this.rpcEnv.setupEndpointRef(RpcAddress.fromHostAndPort(endpoint), RpcNameConstants.MASTER_EP);
        }
        catch (Exception e) {
            LOG.warn("Connect to {} failed.", (Object)endpoint, (Object)e);
        }
        return endpointRef;
    }
}

