/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.memory;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferListener;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferQueue {
    public static final Logger logger = LoggerFactory.getLogger(BufferQueue.class);
    private final Queue<ByteBuf> buffers = new ConcurrentLinkedQueue<ByteBuf>();
    private final MemoryManager memoryManager = MemoryManager.instance();
    private final AtomicInteger numBuffersOccupied = new AtomicInteger();
    private final AtomicInteger pendingRequestBuffers = new AtomicInteger();
    private volatile boolean isReleased = false;
    private volatile int localBuffersTarget = 0;

    public int size() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteBuf poll() {
        Queue<ByteBuf> queue = this.buffers;
        synchronized (queue) {
            return this.buffers.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<ByteBuf> availableBuffers) {
        Queue<ByteBuf> queue = this.buffers;
        synchronized (queue) {
            if (!this.isReleased) {
                this.buffers.addAll(availableBuffers);
                this.numBuffersOccupied.addAndGet(availableBuffers.size());
                this.pendingRequestBuffers.addAndGet(-1 * availableBuffers.size());
            } else {
                for (ByteBuf availableBuffer : availableBuffers) {
                    this.memoryManager.recycleReadBuffer(availableBuffer);
                }
            }
        }
    }

    public void recycle(ByteBuf buffer) {
        if (this.numBuffersOccupied.get() > this.localBuffersTarget) {
            this.recycleToGlobalPool(buffer);
        } else {
            this.recycleToLocalPool(buffer);
        }
    }

    public void recycleToGlobalPool(ByteBuf buffer) {
        this.numBuffersOccupied.decrementAndGet();
        this.memoryManager.recycleReadBuffer(buffer);
    }

    public void recycleToLocalPool(ByteBuf buffer) {
        buffer.clear();
        this.buffers.add(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim() {
        ArrayList<ByteBuf> buffersToFree = new ArrayList<ByteBuf>();
        BufferQueue bufferQueue = this;
        synchronized (bufferQueue) {
            ByteBuf buffer;
            while (this.numBuffersOccupied.get() > this.localBuffersTarget && (buffer = this.poll()) != null) {
                buffersToFree.add(buffer);
                this.numBuffersOccupied.decrementAndGet();
            }
        }
        if (!buffersToFree.isEmpty()) {
            buffersToFree.forEach(this.memoryManager::recycleReadBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Queue<ByteBuf> queue = this.buffers;
        synchronized (queue) {
            this.isReleased = true;
            this.buffers.forEach(this::recycleToGlobalPool);
            this.buffers.clear();
        }
        this.pendingRequestBuffers.set(0);
        this.numBuffersOccupied.set(0);
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    public int getLocalBuffersTarget() {
        return this.localBuffersTarget;
    }

    public void setLocalBuffersTarget(int localBuffersTarget) {
        this.localBuffersTarget = localBuffersTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryApplyNewBuffers(int readerSize, int bufferSize, ReadBufferListener readBufferListener) {
        if (readerSize != 0) {
            BufferQueue bufferQueue = this;
            synchronized (bufferQueue) {
                int occupiedSnapshot = this.numBuffersOccupied.get();
                int pendingSnapShot = this.pendingRequestBuffers.get();
                if (occupiedSnapshot + pendingSnapShot < this.localBuffersTarget) {
                    int newBuffersCount = this.localBuffersTarget - occupiedSnapshot - pendingSnapShot;
                    logger.debug("apply new buffers {} while current buffer queue size {} with read count {}", new Object[]{newBuffersCount, this.numBuffersOccupied.get(), readerSize});
                    this.pendingRequestBuffers.addAndGet(newBuffersCount);
                    this.memoryManager.requestReadBuffers(new ReadBufferRequest(newBuffersCount, bufferSize, readBufferListener));
                }
            }
        }
    }

    public boolean bufferAvailable() {
        return !this.buffers.isEmpty();
    }
}

