/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;

public final class StorageImplUtils {
    private StorageImplUtils() {
    }

    public static RaftStorageImpl newRaftStorage(File dir, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy, RaftStorage.StartupOption option, long storageFeeSpaceMin) throws IOException {
        RaftStorageImpl raftStorage;
        RaftStorage.LOG.debug("newRaftStorage: {}, {}, {}, {}", new Object[]{dir, logCorruptionPolicy, option, storageFeeSpaceMin});
        TimeDuration sleepTime = TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            raftStorage = (RaftStorageImpl)JavaUtils.attemptRepeatedly(() -> new RaftStorageImpl(dir, logCorruptionPolicy, option, storageFeeSpaceMin), (int)5, (TimeDuration)sleepTime, (String)"new RaftStorageImpl", (Logger)RaftStorage.LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)("Interrupted when creating RaftStorage " + dir), (InterruptedException)e);
        }
        return raftStorage;
    }
}

