/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.jwk;

import java.security.cert.X509Certificate;
import java.text.ParseException;

public enum KeyUse {
    SIGNATURE("sig"),
    ENCRYPTION("enc");

    private final String identifier;

    private KeyUse(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("The key use identifier must not be null");
        }
        this.identifier = identifier;
    }

    public String identifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier();
    }

    public static KeyUse parse(String s2) throws ParseException {
        if (s2 == null) {
            return null;
        }
        KeyUse[] keyUseArray = KeyUse.values();
        int n = keyUseArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyUse use = keyUseArray[n2];
            if (s2.equals(use.identifier)) {
                return use;
            }
            ++n2;
        }
        throw new ParseException("Invalid JWK use: " + s2, 0);
    }

    public static KeyUse from(X509Certificate cert) {
        if (cert.getKeyUsage() == null) {
            return null;
        }
        if (cert.getKeyUsage()[1]) {
            return SIGNATURE;
        }
        if (cert.getKeyUsage()[0] && cert.getKeyUsage()[2]) {
            return ENCRYPTION;
        }
        if (cert.getKeyUsage()[0] && cert.getKeyUsage()[4]) {
            return ENCRYPTION;
        }
        if (cert.getKeyUsage()[2] || cert.getKeyUsage()[3] || cert.getKeyUsage()[4]) {
            return ENCRYPTION;
        }
        if (cert.getKeyUsage()[5] || cert.getKeyUsage()[6]) {
            return SIGNATURE;
        }
        return null;
    }
}

