/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.KeyLengthException;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESGCM;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AuthenticatedCipherText;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.ByteUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Container;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
class AESGCMKW {
    public static AuthenticatedCipherText encryptCEK(SecretKey cek, Container<byte[]> iv, SecretKey kek, Provider provider) throws JOSEException {
        return AESGCM.encrypt(kek, iv, cek.getEncoded(), new byte[0], provider);
    }

    public static SecretKey decryptCEK(SecretKey kek, byte[] iv, AuthenticatedCipherText authEncrCEK, int keyLength, Provider provider) throws JOSEException {
        byte[] keyBytes = AESGCM.decrypt(kek, iv, authEncrCEK.getCipherText(), new byte[0], authEncrCEK.getAuthenticationTag(), provider);
        if (ByteUtils.safeBitLength(keyBytes) != keyLength) {
            throw new KeyLengthException("CEK key length mismatch: " + ByteUtils.safeBitLength(keyBytes) + " != " + keyLength);
        }
        return new SecretKeySpec(keyBytes, "AES");
    }

    private AESGCMKW() {
    }
}

