/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> rawType) {
        super(rawType, false);
        this._isInt = rawType == BigInteger.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format != null) {
            switch (format.getShape()) {
                case STRING: {
                    return ToStringSerializer.instance;
                }
            }
        }
        return this;
    }

    @Override
    public void serialize(Number value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        if (value instanceof BigDecimal) {
            g2.writeNumber((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            g2.writeNumber((BigInteger)value);
        } else if (value instanceof Long) {
            g2.writeNumber(value.longValue());
        } else if (value instanceof Double) {
            g2.writeNumber(value.doubleValue());
        } else if (value instanceof Float) {
            g2.writeNumber(value.floatValue());
        } else if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
            g2.writeNumber(value.intValue());
        } else {
            g2.writeNumber(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._isInt) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.BIG_INTEGER);
        } else {
            Class h2 = this.handledType();
            if (h2 == BigDecimal.class) {
                this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.BIG_DECIMAL);
            } else {
                visitor.expectNumberFormat(typeHint);
            }
        }
    }
}

