/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.celeborn.common.network.protocol.Encoders;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;

@Deprecated
public final class RegionStart
extends RequestMessage {
    public final byte mode;
    public final String shuffleKey;
    public final String partitionUniqueId;
    public final int attemptId;
    public int currentRegionIndex;
    public Boolean isBroadcast;

    public RegionStart(byte mode, String shuffleKey, String partitionUniqueId, int attemptId, int currentRegionIndex, Boolean isBroadcast) {
        this.mode = mode;
        this.shuffleKey = shuffleKey;
        this.partitionUniqueId = partitionUniqueId;
        this.attemptId = attemptId;
        this.currentRegionIndex = currentRegionIndex;
        this.isBroadcast = isBroadcast;
    }

    @Override
    public Message.Type type() {
        return Message.Type.REGION_START;
    }

    @Override
    public int encodedLength() {
        return 1 + Encoders.Strings.encodedLength(this.shuffleKey) + Encoders.Strings.encodedLength(this.partitionUniqueId) + 4 + 4 + 1;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte((int)this.mode);
        Encoders.Strings.encode(buf, this.shuffleKey);
        Encoders.Strings.encode(buf, this.partitionUniqueId);
        buf.writeInt(this.attemptId);
        buf.writeInt(this.currentRegionIndex);
        buf.writeBoolean(this.isBroadcast.booleanValue());
    }

    public static RegionStart decode(ByteBuf buf) {
        byte mode = buf.readByte();
        String shuffleKey = Encoders.Strings.decode(buf);
        String partitionUniqueId = Encoders.Strings.decode(buf);
        int attemptId = buf.readInt();
        int currentRegionIndex = buf.readInt();
        boolean isBroadCast = buf.readBoolean();
        return new RegionStart(mode, shuffleKey, partitionUniqueId, attemptId, currentRegionIndex, isBroadCast);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mode, this.shuffleKey, this.partitionUniqueId, this.attemptId, this.currentRegionIndex, this.isBroadcast});
    }

    public boolean equals(Object other) {
        if (other instanceof RegionStart) {
            RegionStart o = (RegionStart)other;
            return this.mode == o.mode && this.shuffleKey.equals(o.shuffleKey) && this.partitionUniqueId.equals(o.partitionUniqueId) && this.attemptId == o.attemptId && this.currentRegionIndex == o.currentRegionIndex && this.isBroadcast == o.isBroadcast && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mode", (int)this.mode).add("shuffleKey", (Object)this.shuffleKey).add("partitionUniqueId", (Object)this.partitionUniqueId).add("attemptId", this.attemptId).add("currentRegionIndex", this.currentRegionIndex).add("isBroadcast", (Object)this.isBroadcast).toString();
    }
}

