/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.Encoders;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;

public final class PushMergedData
extends RequestMessage {
    public long requestId;
    public final byte mode;
    public final String shuffleKey;
    public final String[] partitionUniqueIds;
    public final int[] batchOffsets;

    public PushMergedData(byte mode, String shuffleKey, String[] partitionIds, int[] batchOffsets, ManagedBuffer body) {
        this(0L, mode, shuffleKey, partitionIds, batchOffsets, body);
    }

    private PushMergedData(long requestId, byte mode, String shuffleKey, String[] partitionUniqueIds, int[] batchOffsets, ManagedBuffer body) {
        super(body);
        this.requestId = requestId;
        this.mode = mode;
        this.shuffleKey = shuffleKey;
        this.partitionUniqueIds = partitionUniqueIds;
        this.batchOffsets = batchOffsets;
    }

    @Override
    public Message.Type type() {
        return Message.Type.PUSH_MERGED_DATA;
    }

    @Override
    public int encodedLength() {
        return 9 + Encoders.Strings.encodedLength(this.shuffleKey) + Encoders.StringArrays.encodedLength(this.partitionUniqueIds) + Encoders.IntArrays.encodedLength(this.batchOffsets);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeByte((int)this.mode);
        Encoders.Strings.encode(buf, this.shuffleKey);
        Encoders.StringArrays.encode(buf, this.partitionUniqueIds);
        Encoders.IntArrays.encode(buf, this.batchOffsets);
    }

    public static PushMergedData decode(ByteBuf buf) {
        return PushMergedData.decode(buf, true);
    }

    public static PushMergedData decode(ByteBuf buf, boolean decodeBody) {
        long requestId = buf.readLong();
        byte mode = buf.readByte();
        String shuffleKey = Encoders.Strings.decode(buf);
        String[] partitionIds = Encoders.StringArrays.decode(buf);
        int[] batchOffsets = Encoders.IntArrays.decode(buf);
        if (decodeBody) {
            return new PushMergedData(requestId, mode, shuffleKey, partitionIds, batchOffsets, new NettyManagedBuffer(buf));
        }
        return new PushMergedData(requestId, mode, shuffleKey, partitionIds, batchOffsets, NettyManagedBuffer.EmptyBuffer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestId, this.mode, this.shuffleKey, this.partitionUniqueIds, this.batchOffsets, this.body()});
    }

    public boolean equals(Object other) {
        if (other instanceof PushMergedData) {
            PushMergedData o = (PushMergedData)other;
            return this.requestId == o.requestId && this.mode == o.mode && this.shuffleKey.equals(o.shuffleKey) && Arrays.equals(this.partitionUniqueIds, o.partitionUniqueIds) && Arrays.equals(this.batchOffsets, o.batchOffsets) && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("requestId", this.requestId).add("mode", (int)this.mode).add("shuffleKey", (Object)this.shuffleKey).add("partitionIds", (Object)Arrays.toString(this.partitionUniqueIds)).add("batchOffsets", (Object)Arrays.toString(this.batchOffsets)).add("body size", this.body().size()).toString();
    }
}

