/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.plugin.flink.buffer.Buffer;
import org.apache.celeborn.plugin.flink.buffer.BufferRecycler;
import org.apache.celeborn.plugin.flink.buffer.CreditListener;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferBufferPool
implements BufferRecycler {
    private static Logger logger = LoggerFactory.getLogger(TransferBufferPool.class);
    private static final int MIN_CREDITS_TO_NOTIFY = 2;
    private final Object lock = new Object();
    private final Queue<ByteBuf> buffers = new ArrayDeque<ByteBuf>();
    @GuardedBy(value="lock")
    private final Queue<CreditListener> listeners = new ArrayDeque<CreditListener>();
    @GuardedBy(value="lock")
    private int numAvailableBuffers;
    @GuardedBy(value="lock")
    private boolean isDestroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferBufferPool(Collection<ByteBuf> initialBuffers) {
        Object object = this.lock;
        synchronized (object) {
            this.buffers.addAll(initialBuffers);
            this.numAvailableBuffers += initialBuffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf requestBuffer() {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isDestroyed, "Buffer pool has been destroyed.");
            return this.buffers.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuffers(List<? extends ByteBuf> byteBufs) {
        List<CreditAssignment> creditAssignments;
        Iterator<CreditAssignment> iterator = this.lock;
        synchronized (iterator) {
            if (this.isDestroyed) {
                byteBufs.forEach(ReferenceCounted::release);
                return;
            }
            this.buffers.addAll(byteBufs);
            this.numAvailableBuffers += byteBufs.size();
            creditAssignments = this.dispatchReservedCredits();
        }
        for (CreditAssignment creditAssignment : creditAssignments) {
            creditAssignment.getCreditListener().notifyAvailableCredits(creditAssignment.getNumCredits());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserveBuffers(CreditListener creditListener, int numRequiredBuffers) {
        int numCredits;
        CreditListener listener = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.isDestroyed) {
                throw new IllegalStateException("Buffer pool has been destroyed.");
            }
            if (numRequiredBuffers > this.numAvailableBuffers) {
                creditListener.increaseNumCreditsNeeded(numRequiredBuffers - this.numAvailableBuffers);
            }
            if (!creditListener.isRegistered() && creditListener.getNumCreditsNeeded() > 0) {
                this.listeners.add(creditListener);
                creditListener.setRegistered(true);
            }
            if ((numCredits = Math.min(this.numAvailableBuffers, numRequiredBuffers)) > 0) {
                this.numAvailableBuffers -= numCredits;
                listener = creditListener;
            }
            logger.debug("reserveBuffers: numCredits: {}, requiredBuffers: {}", (Object)numCredits, (Object)numRequiredBuffers);
        }
        if (listener != null) {
            listener.notifyAvailableCredits(numCredits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numBuffers() {
        Object object = this.lock;
        synchronized (object) {
            return this.buffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.isDestroyed = true;
            this.listeners.clear();
            this.buffers.forEach(ReferenceCounted::release);
            this.buffers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            return this.isDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(ByteBuffer buffer) {
        List<CreditAssignment> creditAssignments;
        Iterator<CreditAssignment> iterator = this.lock;
        synchronized (iterator) {
            if (this.isDestroyed) {
                return;
            }
            this.buffers.add((ByteBuf)new Buffer(buffer, this, 0));
            ++this.numAvailableBuffers;
            creditAssignments = this.dispatchReservedCredits();
        }
        for (CreditAssignment creditAssignment : creditAssignments) {
            creditAssignment.getCreditListener().notifyAvailableCredits(creditAssignment.getNumCredits());
        }
    }

    private int assignCredits(CreditListener creditListener) {
        assert (Thread.holdsLock(this.lock));
        if (creditListener == null) {
            return 0;
        }
        int numCredits = Math.min(creditListener.getNumCreditsNeeded(), this.numAvailableBuffers);
        if (numCredits > 0) {
            creditListener.decreaseNumCreditsNeeded(numCredits);
            this.numAvailableBuffers -= numCredits;
        }
        if (creditListener.getNumCreditsNeeded() > 0) {
            this.listeners.add(creditListener);
        } else {
            creditListener.setRegistered(false);
        }
        return numCredits;
    }

    private List<CreditAssignment> dispatchReservedCredits() {
        assert (Thread.holdsLock(this.lock));
        if (this.numAvailableBuffers < 2 || this.listeners.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<CreditAssignment> creditAssignments = new ArrayList<CreditAssignment>();
        while (this.numAvailableBuffers > 0 && this.listeners.size() > 0) {
            CreditListener creditListener = this.listeners.poll();
            int numCredits = this.assignCredits(creditListener);
            if (numCredits <= 0) continue;
            creditAssignments.add(new CreditAssignment(numCredits, creditListener));
        }
        return creditAssignments;
    }

    private static class CreditAssignment {
        private final int numCredits;
        private final CreditListener creditListener;

        CreditAssignment(int numCredits, CreditListener creditListener) {
            Utils.checkArgument(numCredits > 0, "Must be positive.");
            Utils.checkArgument(creditListener != null, "Must be not null.");
            this.numCredits = numCredits;
            this.creditListener = creditListener;
        }

        public int getNumCredits() {
            return this.numCredits;
        }

        public CreditListener getCreditListener() {
            return this.creditListener;
        }
    }
}

