/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.exception.PartitionUnRetryAbleException;

public class ExceptionUtils {
    public static void wrapAndThrowIOException(Exception exception) throws IOException {
        if (exception instanceof CelebornIOException) {
            throw (CelebornIOException)exception;
        }
        if (exception instanceof IOException) {
            throw new CelebornIOException(exception);
        }
        throw new CelebornIOException(exception.getMessage(), (Throwable)exception);
    }

    public static Throwable wrapIOExceptionToUnRetryable(Throwable throwable) {
        if (throwable instanceof IOException) {
            return new PartitionUnRetryAbleException(throwable.getMessage(), throwable);
        }
        return throwable;
    }

    public static String stringifyException(Throwable exception) {
        if (exception == null) {
            return "(null)";
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            exception.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable throwable) {
            return exception.getClass().getName() + " (error while printing stack trace)";
        }
    }
}

