/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.io.netty.util.ReferenceCounted;
import org.apache.celeborn.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPartitionReader
implements PartitionReader {
    private static final Logger logger = LoggerFactory.getLogger(LocalPartitionReader.class);
    private static volatile ThreadPoolExecutor readLocalShufflePool;
    private final LinkedBlockingQueue<ByteBuf> results;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private final int fetchMaxReqsInFlight;
    private final PartitionLocation location;
    private volatile boolean closed = false;
    private final int numChunks;
    private int returnedChunks = 0;
    private int chunkIndex = 0;
    private String fullPath;
    private boolean mapRangeRead = false;
    private FileChannel shuffleChannel;
    private List<Long> chunkOffsets;
    private AtomicBoolean pendingFetchTask = new AtomicBoolean(false);
    private MetricsCallback metricsCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LocalPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex, MetricsCallback metricsCallback) throws IOException {
        PbStreamHandler streamHandle;
        if (readLocalShufflePool == null) {
            Class<LocalPartitionReader> clazz = LocalPartitionReader.class;
            // MONITORENTER : org.apache.celeborn.client.read.LocalPartitionReader.class
            if (readLocalShufflePool == null) {
                readLocalShufflePool = ThreadUtils.newDaemonCachedThreadPool("local-shuffle-reader-thread", conf.readLocalShuffleThreads(), 60);
            }
            // MONITOREXIT : clazz
        }
        this.fetchMaxReqsInFlight = conf.clientFetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.location = location;
        this.metricsCallback = metricsCallback;
        long fetchTimeoutMs = conf.clientFetchTimeoutMs();
        try {
            TransportClient client = clientFactory.createClient(location.getHost(), location.getFetchPort(), 0);
            TransportMessage openStreamMsg = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(shuffleKey).setFileName(location.getFileName()).setStartIndex(startMapIndex).setEndIndex(endMapIndex).setReadLocalShuffle(true).build().toByteArray());
            ByteBuffer response = client.sendRpcSync(openStreamMsg.toByteBuffer(), fetchTimeoutMs);
            streamHandle = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("Read shuffle file from local file failed, partition location: " + location + " filePath: " + location.getStorageInfo().getFilePath(), e);
        }
        this.chunkOffsets = new ArrayList<Long>(streamHandle.getChunkOffsetsList());
        this.numChunks = streamHandle.getNumChunks();
        this.fullPath = streamHandle.getFullPath();
        this.mapRangeRead = endMapIndex != Integer.MAX_VALUE;
        logger.debug("Local partition reader {} offsets:{}", (Object)location.getStorageInfo().getFilePath(), (Object)StringUtils.join(this.chunkOffsets, ","));
        ShuffleClient.incrementLocalReadCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFetchChunks(int chunkIndex, int toFetch) {
        try {
            if (this.shuffleChannel == null) {
                this.shuffleChannel = FileChannelUtils.openReadableFileChannel(this.fullPath);
                if (this.mapRangeRead) {
                    this.shuffleChannel.position(this.chunkOffsets.get(0));
                }
            }
            for (int i = 0; i < toFetch; ++i) {
                long offset = this.chunkOffsets.get(chunkIndex + i);
                long length = this.chunkOffsets.get(chunkIndex + i + 1) - offset;
                logger.debug("Read {} offset {} length {}", new Object[]{chunkIndex, offset, length});
                ByteBuffer buffer = ByteBuffer.allocate((int)length);
                while (buffer.hasRemaining()) {
                    if (-1 != this.shuffleChannel.read(buffer)) continue;
                    throw new CelebornIOException("Read local file " + this.location.getStorageInfo().getFilePath() + " failed");
                }
                buffer.flip();
                LocalPartitionReader localPartitionReader = this;
                synchronized (localPartitionReader) {
                    if (!this.closed) {
                        this.results.put(Unpooled.wrappedBuffer(buffer));
                        logger.debug("Add index {} to results", (Object)(chunkIndex + i));
                    }
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            logger.warn("Read thread is interrupted.", (Throwable)e);
        }
        catch (Exception ioe) {
            logger.error("Read thread encountered error.", (Throwable)ioe);
            if (ioe instanceof CelebornIOException) {
                this.exception.set((IOException)ioe);
            }
            this.exception.set(new CelebornIOException("Read thread encountered error", (Throwable)ioe));
        }
        this.pendingFetchTask.compareAndSet(true, false);
    }

    private void fetchChunks() {
        int inFlight = this.chunkIndex - this.returnedChunks;
        if (inFlight < this.fetchMaxReqsInFlight) {
            int toFetch = Math.min(this.fetchMaxReqsInFlight - inFlight + 1, this.numChunks - this.chunkIndex);
            if (this.pendingFetchTask.compareAndSet(false, true)) {
                logger.debug("Trigger local reader fetch chunk with {} and fetch {} chunks", (Object)this.chunkIndex, (Object)toFetch);
                int currentIndex = this.chunkIndex;
                readLocalShufflePool.submit(() -> this.doFetchChunks(currentIndex, toFetch));
                this.chunkIndex += toFetch;
            }
        }
    }

    @Override
    public boolean hasNext() {
        logger.debug("Check has next current index: {} chunks {}", (Object)this.returnedChunks, (Object)this.numChunks);
        return this.returnedChunks < this.numChunks;
    }

    @Override
    public ByteBuf next() throws IOException, InterruptedException {
        this.checkException();
        if (this.chunkIndex < this.numChunks) {
            this.fetchChunks();
        }
        ByteBuf chunk = null;
        try {
            while (chunk == null) {
                this.checkException();
                Long startFetchWait = System.nanoTime();
                chunk = this.results.poll(100L, TimeUnit.MILLISECONDS);
                this.metricsCallback.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
                logger.debug("Poll result with result size: {}", (Object)this.results.size());
            }
        }
        catch (InterruptedException e) {
            logger.error("PartitionReader thread interrupted while fetching data.");
            throw e;
        }
        ++this.returnedChunks;
        return chunk;
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LocalPartitionReader localPartitionReader = this;
        synchronized (localPartitionReader) {
            this.closed = true;
            if (!this.results.isEmpty()) {
                this.results.forEach(ReferenceCounted::release);
            }
            this.results.clear();
        }
        try {
            if (this.shuffleChannel != null) {
                this.shuffleChannel.close();
            }
        }
        catch (IOException e) {
            logger.warn("Close local shuffle file failed.", (Throwable)e);
        }
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }
}

