/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.util.Utils$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CelebornHadoopUtils$
implements Logging {
    public static final CelebornHadoopUtils$ MODULE$;
    private AtomicBoolean logPrinted;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CelebornHadoopUtils$();
    }

    private Logger log$lzycompute() {
        CelebornHadoopUtils$ celebornHadoopUtils$ = this;
        synchronized (celebornHadoopUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    private AtomicBoolean logPrinted() {
        return this.logPrinted;
    }

    private void logPrinted_$eq(AtomicBoolean x$1) {
        this.logPrinted = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(CelebornConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        if (new StringOps(Predef$.MODULE$.augmentString(conf.hdfsDir())).nonEmpty()) {
            Path path = new Path(conf.hdfsDir());
            String scheme = path.toUri().getScheme();
            String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
            hadoopConf.set("dfs.replication", "2");
            hadoopConf.set(disableCacheName, "false");
            if (this.logPrinted().compareAndSet(false, true)) {
                this.logInfo((Function0<String>)new Serializable(disableCacheName){
                    public static final long serialVersionUID = 0L;
                    private final String disableCacheName$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Celeborn overrides some HDFS settings defined in Hadoop configuration files, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"including '", "=false' and 'dfs.replication=2'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.disableCacheName$1}))).append((Object)"It can be overridden again in Celeborn configuration with the additional ").append((Object)"prefix 'celeborn.hadoop.', e.g. 'celeborn.hadoop.dfs.replication=3'").toString();
                    }
                    {
                        this.disableCacheName$1 = disableCacheName$1;
                    }
                });
            }
        }
        this.appendSparkHadoopConfigs(conf, hadoopConf);
        return var2_2;
    }

    private void appendSparkHadoopConfigs(CelebornConf conf, Configuration hadoopConf) {
        Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith("celeborn.hadoop.");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).foreach((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final void apply(Tuple2<String, String> x$2) {
                Tuple2<String, String> tuple2 = x$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.hadoopConf$1.set(key.substring("celeborn.hadoop.".length()), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
    }

    public FileSystem getHadoopFS(CelebornConf conf) {
        return new Path(conf.hdfsDir()).getFileSystem(this.newConfiguration(conf));
    }

    public void deleteHDFSPathOrLogError(FileSystem hadoopFs, Path path, boolean recursive) {
        try {
            long startTime = System.currentTimeMillis();
            hadoopFs.delete(path, recursive);
            this.logInfo((Function0<String>)new Serializable(path, recursive, startTime){
                public static final long serialVersionUID = 0L;
                private final Path path$1;
                private final boolean recursive$1;
                private final long startTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete HDFS ", "(recursive=", ") costs "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, BoxesRunTime.boxToBoolean((boolean)this.recursive$1)}))).append((Object)Utils$.MODULE$.msDurationToString(System.currentTimeMillis() - this.startTime$1)).toString();
                }
                {
                    this.path$1 = path$1;
                    this.recursive$1 = recursive$1;
                    this.startTime$1 = startTime$1;
                }
            });
        }
        catch (IOException iOException) {
            this.logError((Function0<String>)new Serializable(path, recursive){
                public static final long serialVersionUID = 0L;
                private final Path path$1;
                private final boolean recursive$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete HDFS ", "(recursive=", ") due to: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, BoxesRunTime.boxToBoolean((boolean)this.recursive$1)}));
                }
                {
                    this.path$1 = path$1;
                    this.recursive$1 = recursive$1;
                }
            }, iOException);
        }
    }

    private CelebornHadoopUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.logPrinted = new AtomicBoolean(false);
    }
}

