/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.ShuffleMode;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.TaskContext;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.celeborn.CelebornShuffleFallbackPolicyRunner;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.celeborn.SortBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkShuffleManager
implements ShuffleManager {
    private static final Logger logger = LoggerFactory.getLogger(SparkShuffleManager.class);
    private static final String SORT_SHUFFLE_MANAGER_NAME = "org.apache.spark.shuffle.sort.SortShuffleManager";
    private static final String LOCAL_SHUFFLE_READER_KEY = "spark.sql.adaptive.localShuffleReader.enabled";
    private final SparkConf conf;
    private final Boolean isDriver;
    private final CelebornConf celebornConf;
    private final int cores;
    private String appUniqueId;
    private LifecycleManager lifecycleManager;
    private ShuffleClient shuffleClient;
    private volatile SortShuffleManager _sortShuffleManager;
    private final ConcurrentHashMap.KeySetView<Integer, Boolean> sortShuffleIds = ConcurrentHashMap.newKeySet();
    private final CelebornShuffleFallbackPolicyRunner fallbackPolicyRunner;
    private final ExecutorService[] asyncPushers;
    private AtomicInteger pusherIdx = new AtomicInteger(0);
    private long sendBufferPoolCheckInterval;
    private long sendBufferPoolExpireTimeout;

    public SparkShuffleManager(SparkConf conf, boolean isDriver) {
        if (conf.getBoolean(LOCAL_SHUFFLE_READER_KEY, true)) {
            logger.warn("Detected {} (default is true) is enabled, it's highly recommended to disable it when use Celeborn as Remote Shuffle Service to avoid performance degradation.", (Object)LOCAL_SHUFFLE_READER_KEY);
        }
        this.conf = conf;
        this.isDriver = isDriver;
        this.celebornConf = SparkUtils.fromSparkConf(conf);
        this.cores = this.executorCores(conf);
        this.fallbackPolicyRunner = new CelebornShuffleFallbackPolicyRunner(this.celebornConf);
        if (ShuffleMode.SORT.equals((Object)this.celebornConf.shuffleWriterMode()) && this.celebornConf.clientPushSortPipelineEnabled()) {
            this.asyncPushers = new ExecutorService[this.cores];
            for (int i = 0; i < this.asyncPushers.length; ++i) {
                this.asyncPushers[i] = ThreadUtils.newDaemonSingleThreadExecutor("async-pusher-" + i);
            }
        } else {
            this.asyncPushers = null;
        }
        this.sendBufferPoolCheckInterval = this.celebornConf.clientPushSendBufferPoolExpireCheckInterval();
        this.sendBufferPoolExpireTimeout = this.celebornConf.clientPushSendBufferPoolExpireTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortShuffleManager sortShuffleManager() {
        if (this._sortShuffleManager == null) {
            SparkShuffleManager sparkShuffleManager = this;
            synchronized (sparkShuffleManager) {
                if (this._sortShuffleManager == null) {
                    this._sortShuffleManager = (SortShuffleManager)SparkUtils.instantiateClass(SORT_SHUFFLE_MANAGER_NAME, this.conf, this.isDriver);
                }
            }
        }
        return this._sortShuffleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLifecycleManager() {
        if (this.isDriver.booleanValue() && this.lifecycleManager == null) {
            SparkShuffleManager sparkShuffleManager = this;
            synchronized (sparkShuffleManager) {
                if (this.lifecycleManager == null) {
                    this.lifecycleManager = new LifecycleManager(this.appUniqueId, this.celebornConf);
                }
            }
        }
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        this.appUniqueId = SparkUtils.appUniqueId(dependency.rdd().context());
        this.initializeLifecycleManager();
        if (this.fallbackPolicyRunner.applyAllFallbackPolicy(this.lifecycleManager, dependency.partitioner().numPartitions())) {
            if (this.conf.getBoolean("spark.dynamicAllocation.enabled", false)) {
                logger.error("DRA is enabled but we fallback to vanilla Spark SortShuffleManager for shuffle: {} due to fallback policy. It may cause block can not found when reducer task fetch data.", (Object)shuffleId);
            } else {
                logger.warn("Fallback to vanilla Spark SortShuffleManager for shuffle: {}", (Object)shuffleId);
            }
            this.sortShuffleIds.add(shuffleId);
            return this.sortShuffleManager().registerShuffle(shuffleId, dependency);
        }
        return new CelebornShuffleHandle<K, V, C>(this.appUniqueId, this.lifecycleManager.getHost(), this.lifecycleManager.getPort(), this.lifecycleManager.getUserIdentifier(), shuffleId, dependency.rdd().getNumPartitions(), dependency);
    }

    public boolean unregisterShuffle(int shuffleId) {
        if (this.sortShuffleIds.contains(shuffleId)) {
            return this.sortShuffleManager().unregisterShuffle(shuffleId);
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.unregisterShuffle(shuffleId);
        }
        if (this.shuffleClient != null) {
            this.shuffleClient.cleanupShuffle(shuffleId);
        }
        return true;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.sortShuffleManager().shuffleBlockResolver();
    }

    public void stop() {
        if (this.shuffleClient != null) {
            this.shuffleClient.shutdown();
            ShuffleClient.reset();
            this.shuffleClient = null;
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.stop();
            this.lifecycleManager = null;
        }
        if (this.sortShuffleManager() != null) {
            this.sortShuffleManager().stop();
            this._sortShuffleManager = null;
        }
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        try {
            if (handle instanceof CelebornShuffleHandle) {
                CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
                this.shuffleClient = ShuffleClient.get(h.appUniqueId(), h.lifecycleManagerHost(), h.lifecycleManagerPort(), this.celebornConf, h.userIdentifier());
                if (ShuffleMode.SORT.equals((Object)this.celebornConf.shuffleWriterMode())) {
                    ExecutorService pushThread = this.celebornConf.clientPushSortPipelineEnabled() ? this.getPusherThread() : null;
                    return new SortBasedShuffleWriter(h.dependency(), h.numMappers(), context, this.celebornConf, this.shuffleClient, metrics, pushThread, SendBufferPool.get(this.cores, this.sendBufferPoolCheckInterval, this.sendBufferPoolExpireTimeout));
                }
                if (ShuffleMode.HASH.equals((Object)this.celebornConf.shuffleWriterMode())) {
                    return new HashBasedShuffleWriter(h, context, this.celebornConf, this.shuffleClient, metrics, SendBufferPool.get(this.cores, this.sendBufferPoolCheckInterval, this.sendBufferPoolExpireTimeout));
                }
                throw new UnsupportedOperationException("Unrecognized shuffle write mode!" + (Object)((Object)this.celebornConf.shuffleWriterMode()));
            }
            this.sortShuffleIds.add(handle.shuffleId());
            return this.sortShuffleManager().getWriter(handle, mapId, context, metrics);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        if (handle instanceof CelebornShuffleHandle) {
            CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
            return new CelebornShuffleReader(h, startPartition, endPartition, startMapIndex, endMapIndex, context, this.celebornConf, metrics);
        }
        return SparkUtils.getReader(this.sortShuffleManager(), handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        if (handle instanceof CelebornShuffleHandle) {
            CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
            return new CelebornShuffleReader(h, startPartition, endPartition, 0, Integer.MAX_VALUE, context, this.celebornConf, metrics);
        }
        return SparkUtils.getReader(this.sortShuffleManager(), handle, 0, Integer.MAX_VALUE, startPartition, endPartition, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReaderForRange(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        if (handle instanceof CelebornShuffleHandle) {
            CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
            return new CelebornShuffleReader(h, startPartition, endPartition, startMapIndex, endMapIndex, context, this.celebornConf, metrics);
        }
        return SparkUtils.getReader(this.sortShuffleManager(), handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
    }

    private ExecutorService getPusherThread() {
        ExecutorService pusherThread = this.asyncPushers[this.pusherIdx.get() % this.asyncPushers.length];
        this.pusherIdx.incrementAndGet();
        return pusherThread;
    }

    private int executorCores(SparkConf conf) {
        if (Utils.isLocalMaster((SparkConf)conf)) {
            return (Integer)DynMethods.builder("numDriverCores").impl("org.apache.spark.SparkContext$", String.class).build().bind(SparkContext$.MODULE$).invoke(conf.get("spark.master"));
        }
        return conf.getInt("spark.executor.cores", 1);
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }
}

