/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.congestcontrol;

import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.service.deploy.worker.congestcontrol.TimeSlidingHub;
import org.apache.commons.lang3.tuple.Pair;

public class BufferStatusHub
extends TimeSlidingHub<BufferStatusNode> {
    public BufferStatusHub(int timeWindowsInSecs) {
        super(timeWindowsInSecs);
    }

    @Override
    protected BufferStatusNode newEmptyNode() {
        return new BufferStatusNode();
    }

    public long avgBytesPerSec() {
        Pair sumInfo = this.sum();
        long currentNumBytes = ((BufferStatusNode)sumInfo.getKey()).numBytes();
        if (currentNumBytes > 0L) {
            return currentNumBytes * 1000L / ((long)((Integer)sumInfo.getRight()).intValue() * 1000L);
        }
        return 0L;
    }

    public static class BufferStatusNode
    implements TimeSlidingHub.TimeSlidingNode {
        private final LongAdder numBytes = new LongAdder();

        public BufferStatusNode(long numBytes) {
            if (numBytes != 0L) {
                this.numBytes.add(numBytes);
            }
        }

        public BufferStatusNode() {
            this(0L);
        }

        @Override
        public void combineNode(TimeSlidingHub.TimeSlidingNode node) {
            BufferStatusNode needToCombined = (BufferStatusNode)node;
            this.numBytes.add(needToCombined.numBytes());
        }

        @Override
        public void separateNode(TimeSlidingHub.TimeSlidingNode node) {
            BufferStatusNode needToCombined = (BufferStatusNode)node;
            this.numBytes.add(-needToCombined.numBytes());
        }

        @Override
        public TimeSlidingHub.TimeSlidingNode clone() {
            return new BufferStatusNode(this.numBytes());
        }

        public long numBytes() {
            return this.numBytes.sum();
        }

        public String toString() {
            return String.format("BufferStatusNode: {bytes: %s}", this.numBytes.sum());
        }
    }
}

