/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.client.ChunkFetchFailureException;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;
import org.apache.celeborn.common.network.server.MessageHandler;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.read.FetchRequestInfo;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.write.PushRequestInfo;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportResponseHandler
extends MessageHandler<ResponseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportResponseHandler.class);
    private final TransportConf conf;
    private final Channel channel;
    private final Map<StreamChunkSlice, FetchRequestInfo> outstandingFetches;
    private final Map<Long, RpcResponseCallback> outstandingRpcs;
    private final ConcurrentHashMap<Long, PushRequestInfo> outstandingPushes;
    private final AtomicLong timeOfLastRequestNs;
    private final long pushTimeoutCheckerInterval;
    private static ScheduledExecutorService pushTimeoutChecker = null;
    private ScheduledFuture pushCheckerScheduleFuture;
    private final long fetchTimeoutCheckerInterval;
    private static ScheduledExecutorService fetchTimeoutChecker = null;
    private ScheduledFuture fetchCheckerScheduleFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportResponseHandler(TransportConf conf, Channel channel) {
        this.conf = conf;
        this.channel = channel;
        this.outstandingFetches = JavaUtils.newConcurrentHashMap();
        this.outstandingRpcs = JavaUtils.newConcurrentHashMap();
        this.outstandingPushes = JavaUtils.newConcurrentHashMap();
        this.timeOfLastRequestNs = new AtomicLong(0L);
        this.pushTimeoutCheckerInterval = conf.pushDataTimeoutCheckIntervalMs();
        this.fetchTimeoutCheckerInterval = conf.fetchDataTimeoutCheckIntervalMs();
        String module = conf.getModuleName();
        boolean checkPushTimeout = false;
        boolean checkFetchTimeout = false;
        if ("data".equals(module)) {
            checkPushTimeout = true;
            checkFetchTimeout = true;
        } else if ("push".equals(module)) {
            checkPushTimeout = true;
        }
        Class<TransportResponseHandler> clazz = TransportResponseHandler.class;
        synchronized (TransportResponseHandler.class) {
            if (checkPushTimeout) {
                if (pushTimeoutChecker == null) {
                    pushTimeoutChecker = ThreadUtils.newDaemonThreadPoolScheduledExecutor("push-timeout-checker", conf.pushDataTimeoutCheckerThreads());
                }
                if (checkFetchTimeout && fetchTimeoutChecker == null) {
                    fetchTimeoutChecker = ThreadUtils.newDaemonThreadPoolScheduledExecutor("fetch-timeout-checker", conf.fetchDataTimeoutCheckerThreads());
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (checkPushTimeout) {
                this.pushCheckerScheduleFuture = pushTimeoutChecker.scheduleAtFixedRate(() -> this.failExpiredPushRequest(), this.pushTimeoutCheckerInterval, this.pushTimeoutCheckerInterval, TimeUnit.MILLISECONDS);
            }
            if (checkFetchTimeout) {
                this.fetchCheckerScheduleFuture = fetchTimeoutChecker.scheduleAtFixedRate(() -> this.failExpiredFetchRequest(), this.fetchTimeoutCheckerInterval, this.fetchTimeoutCheckerInterval, TimeUnit.MILLISECONDS);
            }
            return;
        }
    }

    public void failExpiredPushRequest() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<Long, PushRequestInfo> entry : this.outstandingPushes.entrySet()) {
            PushRequestInfo info;
            if (entry.getValue().dueTime > currentTime || (info = this.outstandingPushes.remove(entry.getKey())) == null) continue;
            if (info.channelFuture != null) {
                info.channelFuture.cancel(true);
            }
            if ("data".equals(this.conf.getModuleName())) {
                info.callback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_TIMEOUT_PRIMARY));
            } else if ("push".equals(this.conf.getModuleName())) {
                info.callback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_TIMEOUT_REPLICA));
            }
            info.channelFuture = null;
            info.callback = null;
        }
    }

    public void failExpiredFetchRequest() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<StreamChunkSlice, FetchRequestInfo> entry : this.outstandingFetches.entrySet()) {
            FetchRequestInfo info;
            if (entry.getValue().dueTime > currentTime || (info = this.outstandingFetches.remove(entry.getKey())) == null) continue;
            if (info.channelFuture != null) {
                info.channelFuture.cancel(true);
            }
            logger.info("Fail expire fetch request {},{},{},{}", new Object[]{entry.getKey().streamId, entry.getKey().chunkIndex, entry.getKey().offset, entry.getKey().len});
            info.callback.onFailure(entry.getKey().chunkIndex, new CelebornIOException(StatusCode.FETCH_DATA_TIMEOUT));
            info.channelFuture = null;
            info.callback = null;
        }
    }

    public void addFetchRequest(StreamChunkSlice streamChunkSlice, FetchRequestInfo info) {
        this.updateTimeOfLastRequest();
        if (this.outstandingFetches.containsKey(streamChunkSlice)) {
            logger.warn("[addFetchRequest] streamChunkSlice {} already exists!", (Object)streamChunkSlice);
        }
        this.outstandingFetches.put(streamChunkSlice, info);
    }

    public void removeFetchRequest(StreamChunkSlice streamChunkSlice) {
        this.outstandingFetches.remove(streamChunkSlice);
    }

    public void addRpcRequest(long requestId, RpcResponseCallback callback) {
        this.updateTimeOfLastRequest();
        if (this.outstandingRpcs.containsKey(requestId)) {
            logger.warn("[addRpcRequest] requestId {} already exists!", (Object)requestId);
        }
        this.outstandingRpcs.put(requestId, callback);
    }

    public void removeRpcRequest(long requestId) {
        this.outstandingRpcs.remove(requestId);
    }

    public void addPushRequest(long requestId, PushRequestInfo info) {
        this.updateTimeOfLastRequest();
        if (this.outstandingPushes.containsKey(requestId)) {
            logger.warn("[addPushRequest] requestId {} already exists!", (Object)requestId);
        }
        this.outstandingPushes.put(requestId, info);
    }

    public void removePushRequest(long requestId) {
        this.outstandingPushes.remove(requestId);
    }

    private void failOutstandingRequests(Throwable cause) {
        for (Map.Entry<StreamChunkSlice, FetchRequestInfo> entry : this.outstandingFetches.entrySet()) {
            try {
                entry.getValue().callback.onFailure(entry.getKey().chunkIndex, cause);
            }
            catch (Exception e) {
                logger.warn("ChunkReceivedCallback.onFailure throws exception", (Throwable)e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.outstandingRpcs.entrySet()) {
            try {
                ((RpcResponseCallback)entry.getValue()).onFailure(cause);
            }
            catch (Exception e) {
                logger.warn("RpcResponseCallback.onFailure throws exception", (Throwable)e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.outstandingPushes.entrySet()) {
            try {
                ((PushRequestInfo)entry.getValue()).callback.onFailure(cause);
            }
            catch (Exception e) {
                logger.warn("RpcResponseCallback.onFailure throws exception", (Throwable)e);
            }
        }
        this.outstandingFetches.clear();
        this.outstandingRpcs.clear();
        this.outstandingPushes.clear();
    }

    @Override
    public void channelActive() {
    }

    @Override
    public void channelInactive() {
        if (this.numOutstandingRequests() > 0) {
            if (logger.isDebugEnabled()) {
                if (this.outstandingFetches.size() > 0) {
                    for (Map.Entry<StreamChunkSlice, FetchRequestInfo> e : this.outstandingFetches.entrySet()) {
                        StreamChunkSlice key = e.getKey();
                        logger.debug("The channel is closed, but there is still outstanding Fetch {}", (Object)key);
                    }
                } else {
                    logger.debug("The channel is closed, the outstanding Fetches are empty");
                }
            }
            String remoteAddress = NettyUtils.getRemoteAddress(this.channel);
            logger.error("Still have {} requests outstanding when connection from {} is closed", (Object)this.numOutstandingRequests(), (Object)remoteAddress);
            this.failOutstandingRequests(new IOException("Connection from " + remoteAddress + " closed"));
        }
        if (this.pushCheckerScheduleFuture != null) {
            this.pushCheckerScheduleFuture.cancel(false);
        }
        if (this.fetchCheckerScheduleFuture != null) {
            this.fetchCheckerScheduleFuture.cancel(false);
        }
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        if (this.numOutstandingRequests() > 0) {
            String remoteAddress = NettyUtils.getRemoteAddress(this.channel);
            logger.error("Still have {} requests outstanding when connection from {} is closed", (Object)this.numOutstandingRequests(), (Object)remoteAddress);
            this.failOutstandingRequests(cause);
        }
        if (this.pushCheckerScheduleFuture != null) {
            this.pushCheckerScheduleFuture.cancel(false);
        }
        if (this.fetchCheckerScheduleFuture != null) {
            this.fetchCheckerScheduleFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ResponseMessage message) throws Exception {
        if (message instanceof ChunkFetchSuccess) {
            ChunkFetchSuccess resp = (ChunkFetchSuccess)message;
            logger.debug("Chunk {} fetch succeeded", (Object)resp.streamChunkSlice);
            FetchRequestInfo info = this.outstandingFetches.remove(resp.streamChunkSlice);
            if (info == null) {
                logger.warn("Ignoring response for block {} from {} since it is not outstanding", (Object)resp.streamChunkSlice, (Object)NettyUtils.getRemoteAddress(this.channel));
                resp.body().release();
            } else {
                try {
                    info.callback.onSuccess(resp.streamChunkSlice.chunkIndex, resp.body());
                }
                finally {
                    resp.body().release();
                }
            }
        } else if (message instanceof ChunkFetchFailure) {
            ChunkFetchFailure resp = (ChunkFetchFailure)message;
            logger.error("chunk {} fetch failed, errorMessage {}", (Object)resp.streamChunkSlice, (Object)resp.errorString);
            FetchRequestInfo info = this.outstandingFetches.remove(resp.streamChunkSlice);
            if (info == null) {
                logger.warn("Ignoring response for block {} from {} ({}) since it is not outstanding", new Object[]{resp.streamChunkSlice, NettyUtils.getRemoteAddress(this.channel), resp.errorString});
            } else {
                logger.warn("Receive ChunkFetchFailure, errorMsg {}", (Object)resp.errorString);
                info.callback.onFailure(resp.streamChunkSlice.chunkIndex, new ChunkFetchFailureException("Failure while fetching " + resp.streamChunkSlice + ": " + resp.errorString));
            }
        } else if (message instanceof RpcResponse) {
            RpcResponse resp = (RpcResponse)message;
            PushRequestInfo info = this.outstandingPushes.remove(resp.requestId);
            if (info == null) {
                RpcResponseCallback listener = this.outstandingRpcs.remove(resp.requestId);
                if (listener == null) {
                    logger.warn("Ignoring response for RPC {} from {} ({} bytes) since it is not outstanding", new Object[]{resp.requestId, NettyUtils.getRemoteAddress(this.channel), resp.body().size()});
                    resp.body().release();
                } else {
                    try {
                        listener.onSuccess(resp.body().nioByteBuffer());
                    }
                    finally {
                        resp.body().release();
                    }
                }
            } else {
                try {
                    info.callback.onSuccess(resp.body().nioByteBuffer());
                }
                finally {
                    resp.body().release();
                }
            }
        } else if (message instanceof RpcFailure) {
            RpcFailure resp = (RpcFailure)message;
            PushRequestInfo info = this.outstandingPushes.remove(resp.requestId);
            if (info == null) {
                RpcResponseCallback listener = this.outstandingRpcs.remove(resp.requestId);
                if (listener == null) {
                    logger.warn("Ignoring response for RPC {} from {} ({}) since it is not outstanding", new Object[]{resp.requestId, NettyUtils.getRemoteAddress(this.channel), resp.errorString});
                } else {
                    listener.onFailure(new IOException(resp.errorString));
                }
            } else {
                info.callback.onFailure(new CelebornIOException(resp.errorString));
            }
        } else {
            throw new IllegalStateException("Unknown response type: " + message.type());
        }
    }

    public int numOutstandingRequests() {
        return this.outstandingFetches.size() + this.outstandingRpcs.size() + this.outstandingPushes.size();
    }

    public long getTimeOfLastRequestNs() {
        return this.timeOfLastRequestNs.get();
    }

    public void updateTimeOfLastRequest() {
        this.timeOfLastRequestNs.set(System.nanoTime());
    }
}

