/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels.store.op;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RemoveFromClusterNodeLabelsRequestPBImpl;

public class RemoveClusterLabelOp
extends FSNodeStoreLogOp<CommonNodeLabelsManager> {
    private Collection<String> labels;
    public static final int OPCODE = 2;

    @Override
    public void write(OutputStream os, CommonNodeLabelsManager mgr) throws IOException {
        ((RemoveFromClusterNodeLabelsRequestPBImpl)RemoveFromClusterNodeLabelsRequest.newInstance(Sets.newHashSet(this.labels.iterator()))).getProto().writeDelimitedTo(os);
    }

    @Override
    public void recover(InputStream is, CommonNodeLabelsManager mgr) throws IOException {
        this.labels = YarnServerResourceManagerServiceProtos.RemoveFromClusterNodeLabelsRequestProto.parseDelimitedFrom(is).getNodeLabelsList();
        mgr.removeFromClusterNodeLabels(this.labels);
    }

    public RemoveClusterLabelOp setLabels(Collection<String> nodeLabels) {
        this.labels = nodeLabels;
        return this;
    }

    public Collection<String> getLabels() {
        return this.labels;
    }

    @Override
    public int getOpCode() {
        return 2;
    }
}

