/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.MachineList;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class DefaultImpersonationProvider
implements ImpersonationProvider {
    private static final String CONF_HOSTS = ".hosts";
    private static final String CONF_USERS = ".users";
    private static final String CONF_GROUPS = ".groups";
    private Map<String, AccessControlList> proxyUserAcl = new HashMap<String, AccessControlList>();
    private Map<String, MachineList> proxyHosts = new HashMap<String, MachineList>();
    private Configuration conf;
    private static DefaultImpersonationProvider testProvider;
    private String configPrefix;

    public static synchronized DefaultImpersonationProvider getTestProvider() {
        if (testProvider == null) {
            testProvider = new DefaultImpersonationProvider();
            testProvider.setConf(new Configuration());
            testProvider.init("hadoop.proxyuser");
        }
        return testProvider;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void init(String configurationPrefix) {
        this.configPrefix = configurationPrefix + (configurationPrefix.endsWith(".") ? "" : ".");
        String prefixRegEx = this.configPrefix.replace(".", "\\.");
        String usersGroupsRegEx = prefixRegEx + "[\\S]*(" + Pattern.quote(CONF_USERS) + "|" + Pattern.quote(CONF_GROUPS) + ")";
        String hostsRegEx = prefixRegEx + "[\\S]*" + Pattern.quote(CONF_HOSTS);
        Map<String, String> allMatchKeys = this.conf.getValByRegex(usersGroupsRegEx);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            String aclKey = this.getAclKey(entry.getKey());
            if (this.proxyUserAcl.containsKey(aclKey)) continue;
            this.proxyUserAcl.put(aclKey, new AccessControlList(allMatchKeys.get(aclKey + CONF_USERS), allMatchKeys.get(aclKey + CONF_GROUPS)));
        }
        allMatchKeys = this.conf.getValByRegex(hostsRegEx);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            this.proxyHosts.put(entry.getKey(), new MachineList(entry.getValue()));
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void authorize(UserGroupInformation user, String remoteAddress) throws AuthorizationException {
        if (user == null) {
            throw new IllegalArgumentException("user is null.");
        }
        UserGroupInformation realUser = user.getRealUser();
        if (realUser == null) {
            return;
        }
        AccessControlList acl = this.proxyUserAcl.get(this.configPrefix + realUser.getShortUserName());
        if (acl == null || !acl.isUserAllowed(user)) {
            throw new AuthorizationException("User: " + realUser.getUserName() + " is not allowed to impersonate " + user.getUserName());
        }
        MachineList MachineList2 = this.proxyHosts.get(this.getProxySuperuserIpConfKey(realUser.getShortUserName()));
        if (MachineList2 == null || !MachineList2.includes(remoteAddress)) {
            throw new AuthorizationException("Unauthorized connection for super-user: " + realUser.getUserName() + " from IP " + remoteAddress);
        }
    }

    private String getAclKey(String key) {
        int endIndex = key.lastIndexOf(".");
        if (endIndex != -1) {
            return key.substring(0, endIndex);
        }
        return key;
    }

    public String getProxySuperuserUserConfKey(String userName) {
        return this.configPrefix + userName + CONF_USERS;
    }

    public String getProxySuperuserGroupConfKey(String userName) {
        return this.configPrefix + userName + CONF_GROUPS;
    }

    public String getProxySuperuserIpConfKey(String userName) {
        return this.configPrefix + userName + CONF_HOSTS;
    }

    @VisibleForTesting
    public Map<String, Collection<String>> getProxyGroups() {
        HashMap<String, Collection<String>> proxyGroups = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, AccessControlList> entry : this.proxyUserAcl.entrySet()) {
            proxyGroups.put(entry.getKey() + CONF_GROUPS, entry.getValue().getGroups());
        }
        return proxyGroups;
    }

    @VisibleForTesting
    public Map<String, Collection<String>> getProxyHosts() {
        HashMap<String, Collection<String>> tmpProxyHosts = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, MachineList> proxyHostEntry : this.proxyHosts.entrySet()) {
            tmpProxyHosts.put(proxyHostEntry.getKey(), proxyHostEntry.getValue().getCollection());
        }
        return tmpProxyHosts;
    }
}

