/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta.ha;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.haclient.MasterNotLeaderException;
import org.apache.celeborn.common.rpc.RpcCallContext;
import org.apache.celeborn.service.deploy.master.clustermeta.AbstractMetaManager;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HAMasterMetaManager;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HARaftServer;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorageUtil;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class HAHelper {
    public static boolean checkShouldProcess(RpcCallContext context, AbstractMetaManager masterStatusSystem) {
        HARaftServer ratisServer = HAHelper.getRatisServer(masterStatusSystem);
        if (ratisServer != null) {
            if (ratisServer.isLeader()) {
                return true;
            }
            HAHelper.sendFailure(context, ratisServer, null);
            return false;
        }
        return true;
    }

    public static void sendFailure(RpcCallContext context, HARaftServer ratisServer, Throwable cause) {
        if (context != null) {
            if (ratisServer != null) {
                if (ratisServer.getCachedLeaderPeerRpcEndpoint().isPresent()) {
                    context.sendFailure((Throwable)new MasterNotLeaderException(ratisServer.getRpcEndpoint(), ratisServer.getCachedLeaderPeerRpcEndpoint().get()));
                } else {
                    context.sendFailure((Throwable)new MasterNotLeaderException(ratisServer.getRpcEndpoint(), "leader is not present"));
                }
            } else {
                context.sendFailure((Throwable)new CelebornIOException(cause.getMessage(), cause));
            }
        }
    }

    public static long getWorkerTimeoutDeadline(AbstractMetaManager masterStatusSystem) {
        HARaftServer ratisServer = HAHelper.getRatisServer(masterStatusSystem);
        if (ratisServer != null) {
            return ratisServer.getWorkerTimeoutDeadline();
        }
        return -1L;
    }

    public static long getAppTimeoutDeadline(AbstractMetaManager masterStatusSystem) {
        HARaftServer ratisServer = HAHelper.getRatisServer(masterStatusSystem);
        if (ratisServer != null) {
            return ratisServer.getAppTimeoutDeadline();
        }
        return -1L;
    }

    public static HARaftServer getRatisServer(AbstractMetaManager masterStatusSystem) {
        if (masterStatusSystem instanceof HAMasterMetaManager) {
            HARaftServer ratisServer = ((HAMasterMetaManager)masterStatusSystem).getRatisServer();
            return ratisServer;
        }
        return null;
    }

    public static ByteString convertRequestToByteString(ResourceProtos.ResourceRequest request) {
        byte[] requestBytes = request.toByteArray();
        return ByteString.copyFrom((byte[])requestBytes);
    }

    public static ResourceProtos.ResourceRequest convertByteStringToRequest(ByteString byteString) throws InvalidProtocolBufferException {
        byte[] bytes = byteString.toByteArray();
        return ResourceProtos.ResourceRequest.parseFrom(bytes);
    }

    public static Message convertResponseToMessage(ResourceProtos.ResourceResponse response) {
        byte[] requestBytes = response.toByteArray();
        return Message.valueOf((ByteString)ByteString.copyFrom((byte[])requestBytes));
    }

    public static File createTempSnapshotFile(SimpleStateMachineStorage storage) throws IOException {
        File tempDir = new File(SimpleStateMachineStorageUtil.getSmDir(storage).getParentFile(), "tmp");
        if (!tempDir.isDirectory() && !tempDir.mkdir()) {
            throw new IOException("Cannot create temporary snapshot directory at " + tempDir.getAbsolutePath());
        }
        return File.createTempFile("raft_snapshot_" + System.currentTimeMillis() + "_", ".dat", tempDir);
    }
}

