/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;

public class ConfigurationManager {
    private final RaftConfigurationImpl initialConf;
    private final NavigableMap<Long, RaftConfigurationImpl> configurations = new TreeMap<Long, RaftConfigurationImpl>();
    private volatile RaftConfigurationImpl currentConf;

    ConfigurationManager(RaftConfigurationImpl initialConf) {
        this.initialConf = initialConf;
        this.currentConf = initialConf;
    }

    synchronized void addConfiguration(RaftConfiguration conf) {
        long logIndex = conf.getLogEntryIndex();
        RaftConfiguration found = (RaftConfiguration)this.configurations.get(logIndex);
        if (found != null) {
            Preconditions.assertTrue((boolean)found.equals(conf));
            return;
        }
        this.addRaftConfigurationImpl(logIndex, (RaftConfigurationImpl)conf);
    }

    private void addRaftConfigurationImpl(long logIndex, RaftConfigurationImpl conf) {
        this.configurations.put(logIndex, conf);
        if (logIndex == this.configurations.lastEntry().getKey()) {
            this.currentConf = conf;
        }
    }

    RaftConfigurationImpl getCurrent() {
        return this.currentConf;
    }

    synchronized RaftConfiguration removeConfigurations(long index) {
        Iterator<Map.Entry<Long, RaftConfigurationImpl>> iter = this.configurations.tailMap(index).entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.currentConf = this.configurations.isEmpty() ? this.initialConf : this.configurations.lastEntry().getValue();
        return this.currentConf;
    }

    synchronized int numOfConf() {
        return 1 + this.configurations.size();
    }

    public synchronized String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ", init=" + this.initialConf + ", confs=" + StringUtils.map2String(this.configurations);
    }
}

