/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.client.ChunkReceivedCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.util.ReferenceCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerPartitionReader
implements PartitionReader {
    private final Logger logger = LoggerFactory.getLogger(WorkerPartitionReader.class);
    private PartitionLocation location;
    private final TransportClientFactory clientFactory;
    private PbStreamHandler streamHandle;
    private int returnedChunks;
    private int chunkIndex;
    private final LinkedBlockingQueue<ByteBuf> results;
    private final ChunkReceivedCallback callback;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private final int fetchMaxReqsInFlight;
    private final long fetchTimeoutMs;
    private boolean closed = false;
    private int fetchChunkRetryCnt;
    private int fetchChunkMaxRetry;
    private final boolean testFetch;

    WorkerPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex, int fetchChunkRetryCnt, int fetchChunkMaxRetry) throws IOException, InterruptedException {
        this.fetchMaxReqsInFlight = conf.clientFetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.fetchTimeoutMs = conf.clientFetchTimeoutMs();
        this.callback = new ChunkReceivedCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    ByteBuf buf = ((NettyManagedBuffer)buffer).getBuf();
                    if (!WorkerPartitionReader.this.closed) {
                        buf.retain();
                        WorkerPartitionReader.this.results.add(buf);
                    }
                }
            }

            @Override
            public void onFailure(int chunkIndex, Throwable e) {
                String errorMsg = "Fetch chunk " + chunkIndex + " failed.";
                WorkerPartitionReader.this.logger.error(errorMsg, e);
                WorkerPartitionReader.this.exception.set(new CelebornIOException(errorMsg, e));
            }
        };
        TransportClient client = null;
        try {
            client = clientFactory.createClient(location.getHost(), location.getFetchPort());
        }
        catch (InterruptedException ie) {
            this.logger.error("PartitionReader thread interrupted while creating client.");
            throw ie;
        }
        TransportMessage openStreamMsg = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(shuffleKey).setFileName(location.getFileName()).setStartIndex(startMapIndex).setEndIndex(endMapIndex).build().toByteArray());
        ByteBuffer response = client.sendRpcSync(openStreamMsg.toByteBuffer(), this.fetchTimeoutMs);
        this.streamHandle = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
        this.location = location;
        this.clientFactory = clientFactory;
        this.fetchChunkRetryCnt = fetchChunkRetryCnt;
        this.fetchChunkMaxRetry = fetchChunkMaxRetry;
        this.testFetch = conf.testFetchFailure();
        ShuffleClient.incrementTotalReadCounter();
    }

    @Override
    public boolean hasNext() {
        return this.returnedChunks < this.streamHandle.getNumChunks();
    }

    @Override
    public ByteBuf next() throws IOException, InterruptedException {
        this.checkException();
        if (this.chunkIndex < this.streamHandle.getNumChunks()) {
            this.fetchChunks();
        }
        ByteBuf chunk = null;
        try {
            while (chunk == null) {
                this.checkException();
                chunk = this.results.poll(500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            this.logger.error("PartitionReader thread interrupted while polling data.");
            throw e;
        }
        ++this.returnedChunks;
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WorkerPartitionReader workerPartitionReader = this;
        synchronized (workerPartitionReader) {
            this.closed = true;
        }
        if (this.results.size() > 0) {
            this.results.forEach(ReferenceCounted::release);
        }
        this.results.clear();
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }

    private void fetchChunks() throws IOException, InterruptedException {
        int inFlight = this.chunkIndex - this.returnedChunks;
        if (inFlight < this.fetchMaxReqsInFlight) {
            int toFetch = Math.min(this.fetchMaxReqsInFlight - inFlight + 1, this.streamHandle.getNumChunks() - this.chunkIndex);
            for (int i = 0; i < toFetch; ++i) {
                if (this.testFetch && this.fetchChunkRetryCnt < this.fetchChunkMaxRetry - 1 && this.chunkIndex == 3) {
                    this.callback.onFailure(this.chunkIndex, new CelebornIOException("Test fetch chunk failure"));
                    continue;
                }
                try {
                    TransportClient client = this.clientFactory.createClient(this.location.getHost(), this.location.getFetchPort());
                    client.fetchChunk(this.streamHandle.getStreamId(), this.chunkIndex, this.fetchTimeoutMs, this.callback);
                    ++this.chunkIndex;
                    continue;
                }
                catch (IOException e) {
                    this.logger.error("fetchChunk for streamId: {}, chunkIndex: {} failed.", new Object[]{this.streamHandle.getStreamId(), this.chunkIndex, e});
                    ExceptionUtils.wrapAndThrowIOException(e);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error("PartitionReader thread interrupted while fetching chunks.");
                    throw e;
                }
            }
        }
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }
}

