/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;

@InterfaceAudience.Private
public class LogAggregationUtils {
    public static final String TMP_FILE_SUFFIX = ".tmp";

    public static Path getRemoteNodeLogFileForApp(Path remoteRootLogDir, ApplicationId appId, String user, NodeId nodeId, String suffix) {
        return new Path(LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, suffix), LogAggregationUtils.getNodeString(nodeId));
    }

    public static Path getRemoteAppLogDir(Path remoteRootLogDir, ApplicationId appId, String user, String suffix) {
        return new Path(LogAggregationUtils.getRemoteLogSuffixedDir(remoteRootLogDir, user, suffix), appId.toString());
    }

    public static Path getRemoteLogSuffixedDir(Path remoteRootLogDir, String user, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user);
        }
        return new Path(LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user), suffix);
    }

    public static Path getRemoteLogUserDir(Path remoteRootLogDir, String user) {
        return new Path(remoteRootLogDir, user);
    }

    @VisibleForTesting
    public static String getNodeString(NodeId nodeId) {
        return nodeId.toString().replace(":", "_");
    }

    @VisibleForTesting
    public static String getNodeString(String nodeId) {
        return nodeId.toString().replace(":", "_");
    }

    public static Path getRemoteAppLogDir(Configuration conf, ApplicationId appId, String appOwner, Path remoteRootLogDir, String suffix) throws IOException {
        Path remoteAppDir = null;
        if (appOwner == null) {
            Path qualifiedRemoteRootLogDir = FileContext.getFileContext(conf).makeQualified(remoteRootLogDir);
            FileContext fc = FileContext.getFileContext(qualifiedRemoteRootLogDir.toUri(), conf);
            Path toMatch = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, "*", suffix);
            FileStatus[] matching = fc.util().globStatus(toMatch);
            if (matching == null || matching.length != 1) {
                throw new IOException("Can not find remote application directory for the application:" + appId);
            }
            remoteAppDir = matching[0].getPath();
        } else {
            remoteAppDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, appOwner, suffix);
        }
        return remoteAppDir;
    }

    public static RemoteIterator<FileStatus> getRemoteNodeFileDir(Configuration conf, ApplicationId appId, String appOwner, Path remoteRootLogDir, String suffix) throws IOException {
        Path remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(conf, appId, appOwner, remoteRootLogDir, suffix);
        RemoteIterator<FileStatus> nodeFiles = null;
        Path qualifiedLogDir = FileContext.getFileContext(conf).makeQualified(remoteAppLogDir);
        nodeFiles = FileContext.getFileContext(qualifiedLogDir.toUri(), conf).listStatus(remoteAppLogDir);
        return nodeFiles;
    }

    public static List<FileStatus> getRemoteNodeFileList(Configuration conf, ApplicationId appId, String appOwner, Path remoteRootLogDir, String suffix) throws IOException {
        Path remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(conf, appId, appOwner, remoteRootLogDir, suffix);
        ArrayList<FileStatus> nodeFiles = new ArrayList<FileStatus>();
        Path qualifiedLogDir = FileContext.getFileContext(conf).makeQualified(remoteAppLogDir);
        nodeFiles.addAll(Arrays.asList(FileContext.getFileContext(qualifiedLogDir.toUri(), conf).util().listStatus(remoteAppLogDir)));
        return nodeFiles;
    }
}

