/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.server.TransportChannelHandler;
import org.apache.celeborn.common.network.util.IOMode;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.network.util.TransportFrameDecoder;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import org.apache.celeborn.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelFuture;
import org.apache.celeborn.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.celeborn.shaded.io.netty.channel.ChannelInitializer;
import org.apache.celeborn.shaded.io.netty.channel.ChannelOption;
import org.apache.celeborn.shaded.io.netty.channel.EventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.socket.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClientFactory
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportClientFactory.class);
    private final TransportContext context;
    private final TransportConf conf;
    private final ConcurrentHashMap<SocketAddress, ClientPool> connectionPool;
    private final Random rand;
    private final int numConnectionsPerPeer;
    private final Class<? extends Channel> socketChannelClass;
    private EventLoopGroup workerGroup;
    protected ByteBufAllocator pooledAllocator;

    public TransportClientFactory(TransportContext context) {
        this.context = Preconditions.checkNotNull(context);
        this.conf = context.getConf();
        this.connectionPool = JavaUtils.newConcurrentHashMap();
        this.numConnectionsPerPeer = this.conf.numConnectionsPerPeer();
        this.rand = new Random();
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        this.socketChannelClass = NettyUtils.getClientChannelClass(ioMode);
        logger.info("mode " + (Object)((Object)ioMode) + " threads " + this.conf.clientThreads());
        this.workerGroup = NettyUtils.createEventLoop(ioMode, this.conf.clientThreads(), this.conf.getModuleName() + "-client");
        this.initializeMemoryAllocator();
    }

    protected void initializeMemoryAllocator() {
        this.pooledAllocator = NettyUtils.getPooledByteBufAllocator(this.conf, null, false);
    }

    public TransportClient createClient(String remoteHost, int remotePort, int partitionId) throws IOException, InterruptedException {
        return this.createClient(remoteHost, remotePort, partitionId, new TransportFrameDecoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient createClient(String remoteHost, int remotePort, int partitionId, ChannelInboundHandlerAdapter decoder) throws IOException, InterruptedException {
        String resolveMsg;
        int clientIndex;
        TransportClient cachedClient;
        InetSocketAddress unresolvedAddress = InetSocketAddress.createUnresolved(remoteHost, remotePort);
        ClientPool clientPool = this.connectionPool.get(unresolvedAddress);
        if (clientPool == null) {
            this.connectionPool.computeIfAbsent(unresolvedAddress, key -> new ClientPool(this.numConnectionsPerPeer));
            clientPool = this.connectionPool.get(unresolvedAddress);
        }
        if ((cachedClient = clientPool.clients[clientIndex = partitionId < 0 ? this.rand.nextInt(this.numConnectionsPerPeer) : partitionId % this.numConnectionsPerPeer]) != null && cachedClient.isActive()) {
            TransportChannelHandler handler;
            TransportChannelHandler transportChannelHandler = handler = cachedClient.getChannel().pipeline().get(TransportChannelHandler.class);
            synchronized (transportChannelHandler) {
                handler.getResponseHandler().updateTimeOfLastRequest();
            }
            if (cachedClient.isActive()) {
                logger.debug("Returning cached connection from {} to {}: {}", new Object[]{cachedClient.getChannel().localAddress(), cachedClient.getSocketAddress(), cachedClient});
                return cachedClient;
            }
        }
        long preResolveHost = System.nanoTime();
        InetSocketAddress resolvedAddress = new InetSocketAddress(remoteHost, remotePort);
        long hostResolveTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - preResolveHost);
        String string = resolveMsg = resolvedAddress.isUnresolved() ? "failed" : "succeed";
        if (hostResolveTimeMs > 2000L) {
            logger.warn("DNS resolution {} for {} took {} ms", new Object[]{resolveMsg, resolvedAddress, hostResolveTimeMs});
        } else {
            logger.trace("DNS resolution {} for {} took {} ms", new Object[]{resolveMsg, resolvedAddress, hostResolveTimeMs});
        }
        Object object = clientPool.locks[clientIndex];
        synchronized (object) {
            cachedClient = clientPool.clients[clientIndex];
            if (cachedClient != null) {
                if (cachedClient.isActive()) {
                    logger.debug("Returning cached connection from {} to {}: {}", new Object[]{cachedClient.getChannel().localAddress(), resolvedAddress, cachedClient});
                    return cachedClient;
                }
                logger.info("Found inactive connection to {}, creating a new one.", (Object)resolvedAddress);
            }
            clientPool.clients[clientIndex] = this.internalCreateClient(resolvedAddress, decoder);
            return clientPool.clients[clientIndex];
        }
    }

    public TransportClient createClient(String remoteHost, int remotePort) throws IOException, InterruptedException {
        return this.createClient(remoteHost, remotePort, -1);
    }

    private TransportClient internalCreateClient(InetSocketAddress address, final ChannelInboundHandlerAdapter decoder) throws IOException, InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(this.socketChannelClass)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.conf.connectTimeoutMs())).option(ChannelOption.ALLOCATOR, this.pooledAllocator);
        if (this.conf.receiveBuf() > 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, this.conf.sendBuf());
        }
        final AtomicReference clientRef = new AtomicReference();
        final AtomicReference channelRef = new AtomicReference();
        bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) {
                TransportChannelHandler clientHandler = TransportClientFactory.this.context.initializePipeline(ch, decoder);
                clientRef.set(clientHandler.getClient());
                channelRef.set(ch);
            }
        });
        ChannelFuture cf = bootstrap.connect(address);
        if (!cf.await(this.conf.connectTimeoutMs())) {
            throw new CelebornIOException(String.format("Connecting to %s timed out (%s ms)", address, this.conf.connectTimeoutMs()));
        }
        if (cf.cause() != null) {
            throw new CelebornIOException(String.format("Failed to connect to %s", address), cf.cause());
        }
        TransportClient client = (TransportClient)clientRef.get();
        assert (client != null) : "Channel future completed successfully with null client";
        logger.debug("Connection from {} to {} successful", (Object)client.getChannel().localAddress(), (Object)address);
        return client;
    }

    @Override
    public void close() {
        for (ClientPool clientPool : this.connectionPool.values()) {
            for (int i = 0; i < clientPool.clients.length; ++i) {
                TransportClient client = clientPool.clients[i];
                if (client == null) continue;
                clientPool.clients[i] = null;
                JavaUtils.closeQuietly(client);
            }
        }
        this.connectionPool.clear();
        if (this.workerGroup != null && !this.workerGroup.isShuttingDown()) {
            this.workerGroup.shutdownGracefully();
        }
    }

    public TransportContext getContext() {
        return this.context;
    }

    private static class ClientPool {
        TransportClient[] clients;
        Object[] locks;

        ClientPool(int size) {
            this.clients = new TransportClient[size];
            this.locks = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.locks[i] = new Object();
            }
        }
    }
}

