/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExecutorUtils;
import org.slf4j.Logger;

public class ThreadUtils {
    public static ThreadFactory createFactoryWithDefaultExceptionHandler(String executorServiceName, Logger LOG) {
        return new ThreadFactoryBuilder().setNameFormat(executorServiceName + "-%d").setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOG.error("exception in serviceName: {}, thread: {}", new Object[]{executorServiceName, t.getName(), e})).build();
    }

    public static void shutdownExecutors(int timeoutSecs, ExecutorService executorService) {
        ExecutorUtils.gracefulShutdown((long)timeoutSecs, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executorService});
    }
}

