/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteShuffleInputGateFactory {
    public static final int MIN_BUFFERS_PER_GATE = 16;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteShuffleInputGateFactory.class);
    protected final int numConcurrentReading;
    protected static final String compressionCodec = "LZ4";
    protected final int networkBufferSize;
    protected final NetworkBufferPool networkBufferPool;
    protected final int numBuffersPerGate;
    protected boolean supportFloatingBuffers;
    protected CelebornConf celebornConf;

    public AbstractRemoteShuffleInputGateFactory(CelebornConf conf, NetworkBufferPool networkBufferPool, int networkBufferSize) {
        this.celebornConf = conf;
        long configuredMemorySize = this.celebornConf.clientFlinkMemoryPerInputGate();
        long minConfiguredMemorySize = this.celebornConf.clientFlinkMemoryPerInputGateMin();
        if (configuredMemorySize < minConfiguredMemorySize) {
            throw new IllegalArgumentException(String.format("Insufficient network memory per input gate, please increase %s to at least %s.", CelebornConf.CLIENT_MEMORY_PER_INPUT_GATE().key(), this.celebornConf.clientFlinkMemoryPerInputGate()));
        }
        this.numBuffersPerGate = Utils.checkedDownCast(configuredMemorySize / (long)networkBufferSize);
        this.supportFloatingBuffers = this.celebornConf.clientFlinkInputGateSupportFloatingBuffer();
        if (this.numBuffersPerGate < 16) {
            throw new IllegalArgumentException(String.format("Insufficient network memory per input gate, please increase %s to at least %d bytes.", CelebornConf.CLIENT_MEMORY_PER_INPUT_GATE().key(), networkBufferSize * 16));
        }
        this.networkBufferSize = networkBufferSize;
        this.numConcurrentReading = this.celebornConf.clientFlinkNumConcurrentReading();
        this.networkBufferPool = networkBufferPool;
    }

    public IndexedInputGate create(String owningTaskName, int gateIndex, InputGateDeploymentDescriptor igdd) {
        LOG.info("Create input gate -- number of buffers per input gate={}, number of concurrent readings={}.", (Object)this.numBuffersPerGate, (Object)this.numConcurrentReading);
        SupplierWithException<BufferPool, IOException> bufferPoolFactory = this.createBufferPoolFactory((BufferPoolFactory)this.networkBufferPool, this.numBuffersPerGate, this.supportFloatingBuffers);
        BufferDecompressor bufferDecompressor = new BufferDecompressor(this.networkBufferSize, compressionCodec);
        return this.createInputGate(owningTaskName, gateIndex, igdd, bufferPoolFactory, bufferDecompressor);
    }

    protected abstract IndexedInputGate createInputGate(String var1, int var2, InputGateDeploymentDescriptor var3, SupplierWithException<BufferPool, IOException> var4, BufferDecompressor var5);

    private SupplierWithException<BufferPool, IOException> createBufferPoolFactory(BufferPoolFactory bufferPoolFactory, int numBuffers, boolean supportFloatingBuffers) {
        if (supportFloatingBuffers) {
            return () -> bufferPoolFactory.createBufferPool(1, numBuffers);
        }
        return () -> bufferPoolFactory.createBufferPool(numBuffers, numBuffers);
    }
}

