/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.listener.WorkerStatusListener;
import org.apache.celeborn.client.listener.WorkersStatus;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\u000b\u0016\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!)q\u0007\u0001C\u0001q!9A\b\u0001b\u0001\n\u0013i\u0004BB!\u0001A\u0003%a\bC\u0004C\u0001\t\u0007I\u0011B\"\t\ry\u0003\u0001\u0015!\u0003E\u0011\u001dy\u0006A1A\u0005\u0002\u0001Da!\u001e\u0001!\u0002\u0013\t\u0007b\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\u0007y\u0002\u0001\u000b\u0011\u0002=\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0011\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0006\u0002!\t!a\"\u0003']{'o[3s'R\fG/^:Ue\u0006\u001c7.\u001a:\u000b\u0005Y9\u0012AB2mS\u0016tGO\u0003\u0002\u00193\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002+/\u000511m\\7n_:L!\u0001L\u0014\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\ty\u0003'D\u0001*\u0013\t\t\u0014F\u0001\u0007DK2,'m\u001c:o\u0007>tg-\u0001\tmS\u001a,7-_2mK6\u000bg.Y4feB\u0011A'N\u0007\u0002+%\u0011a'\u0006\u0002\u0011\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\fa\u0001P5oSRtDcA\u001d;wA\u0011A\u0007\u0001\u0005\u0006[\r\u0001\rA\f\u0005\u0006e\r\u0001\raM\u0001\u001cKb\u001cG.\u001e3fI^{'o[3s\u000bb\u0004\u0018N]3US6,w.\u001e;\u0016\u0003y\u0002\"\u0001I \n\u0005\u0001\u000b#\u0001\u0002'p]\u001e\fA$\u001a=dYV$W\rZ,pe.,'/\u0012=qSJ,G+[7f_V$\b%A\u000bx_J\\WM]*uCR,8\u000fT5ti\u0016tWM]:\u0016\u0003\u0011\u0003B!R(S1:\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\u000bG>t7-\u001e:sK:$(B\u0001&L\u0003\u0011)H/\u001b7\u000b\u00031\u000bAA[1wC&\u0011ajR\u0001\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\u0018B\u0001)R\u0005)YU-_*fiZKWm\u001e\u0006\u0003\u001d\u001e\u0003\"a\u0015,\u000e\u0003QS!!V\u000b\u0002\u00111L7\u000f^3oKJL!a\u0016+\u0003)]{'o[3s'R\fG/^:MSN$XM\\3s!\tIF,D\u0001[\u0015\tY6*\u0001\u0003mC:<\u0017BA/[\u0005\u001d\u0011un\u001c7fC:\fac^8sW\u0016\u00148\u000b^1ukNd\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0010Kb\u001cG.\u001e3fI^{'o[3sgV\t\u0011\r\u0005\u0003GE\u0012T\u0017BA2H\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O&\nA!\\3uC&\u0011\u0011N\u001a\u0002\u000b/>\u00148.\u001a:J]\u001a|\u0007\u0003\u0002\u0011l[zJ!\u0001\\\u0011\u0003\rQ+\b\u000f\\33!\tq7/D\u0001p\u0015\t\u0001\u0018/A\u0004nKN\u001c\u0018mZ3\u000b\u0005IL\u0013\u0001\u00039s_R|7m\u001c7\n\u0005Q|'AC*uCR,8oQ8eK\u0006\u0001R\r_2mk\u0012,GmV8sW\u0016\u00148\u000fI\u0001\u0010g\",H\u000f^5oO^{'o[3sgV\t\u0001\u0010E\u0002zu\u0012l\u0011!S\u0005\u0003w&\u00131aU3u\u0003A\u0019\b.\u001e;uS:<wk\u001c:lKJ\u001c\b%\u0001\u000fsK\u001eL7\u000f^3s/>\u00148.\u001a:Ti\u0006$Xo\u001d'jgR,g.\u001a:\u0015\u0007}\f)\u0001E\u0002!\u0003\u0003I1!a\u0001\"\u0005\u0011)f.\u001b;\t\r\u0005\u001dA\u00021\u0001S\u0003Q9xN]6feN#\u0018\r^;t\u0019&\u001cH/\u001a8fe\u0006)r-\u001a;OK\u0016$7\t[3dW\u0016$wk\u001c:lKJ\u001cHCAA\u0007!\u0015\ty!!\be\u001d\u0011\t\t\"!\u0007\u0011\u0007\u0005M\u0011%\u0004\u0002\u0002\u0016)\u0019\u0011qC\u000f\u0002\rq\u0012xn\u001c;?\u0013\r\tY\"I\u0001\u0007!J,G-\u001a4\n\u0007m\fyBC\u0002\u0002\u001c\u0005\nqb^8sW\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0005\u0003K\tI\u0003E\u0002!\u0003OI!!X\u0011\t\r\u0005-b\u00021\u0001e\u0003\u00199xN]6feR!\u0011QEA\u0018\u0011\u001d\t\td\u0004a\u0001\u0003g\t1\u0001\\8d!\u0011\t)$a\u000e\u000e\u0003EL1!!\u000fr\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dCRLwN\\\u0001\u001bKb\u001cG.\u001e3f/>\u00148.\u001a:Ge>l\u0007+\u0019:uSRLwN\u001c\u000b\b\u007f\u0006}\u0012\u0011JA'\u0011\u001d\t\t\u0005\u0005a\u0001\u0003\u0007\n\u0011b\u001d5vM\u001adW-\u00133\u0011\u0007\u0001\n)%C\u0002\u0002H\u0005\u00121!\u00138u\u0011\u001d\tY\u0005\u0005a\u0001\u0003g\tAb\u001c7e!\u0006\u0014H/\u001b;j_:Da!a\u0014\u0011\u0001\u0004i\u0017!B2bkN,\u0017a\u0005:fG>\u0014HmV8sW\u0016\u0014h)Y5mkJ,GcA@\u0002V!9\u0011qK\tA\u0002\u0005e\u0013\u0001\u00034bS2,(/Z:\u0011\t\u0005m\u0013\u0011\u000f\b\u0005\u0003;\niG\u0004\u0003\u0002`\u0005-d\u0002BA1\u0003SrA!a\u0019\u0002h9!\u00111CA3\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002\u0017/%\u0019\u0011qN\u000b\u0002!1Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018\u0002BA:\u0003k\u0012Ac\u00155vM\u001adWMR1jY\u0016$wk\u001c:lKJ\u001c(bAA8+\u0005I\"/Z7pm\u00164%o\\7Fq\u000edW\u000fZ3e/>\u00148.\u001a:t)\ry\u00181\u0010\u0005\b\u0003{\u0012\u0002\u0019AA@\u0003\u001d9xN]6feN\u0004B!_AAI&\u0019\u00111Q%\u0003\u000f!\u000b7\u000f[*fi\u00069\u0002.\u00198eY\u0016DU-\u0019:uE\u0016\fGOU3ta>t7/\u001a\u000b\u0004\u007f\u0006%\u0005bBAF'\u0001\u0007\u0011QR\u0001\u0004e\u0016\u001c\b\u0003BAH\u0003CsA!!%\u0002\u001e:!\u00111SAN\u001d\u0011\t)*!'\u000f\t\u0005}\u0013qS\u0005\u0003U]I!A]\u0015\n\u0005A\f\u0018bAAP_\u0006y1i\u001c8ue>dW*Z:tC\u001e,7/\u0003\u0003\u0002$\u0006\u0015&\u0001\t%fCJ$(-Z1u\rJ|W.\u00119qY&\u001c\u0017\r^5p]J+7\u000f]8og\u0016T1!a(p\u0001")
public class WorkerStatusTracker
implements Logging {
    private final CelebornConf conf;
    private final LifecycleManager lifecycleManager;
    private final long excludedWorkerExpireTimeout;
    private final ConcurrentHashMap.KeySetView<WorkerStatusListener, Boolean> workerStatusListeners;
    private final ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> excludedWorkers;
    private final Set<WorkerInfo> shuttingWorkers;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerStatusTracker workerStatusTracker = this;
        synchronized (workerStatusTracker) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private long excludedWorkerExpireTimeout() {
        return this.excludedWorkerExpireTimeout;
    }

    private ConcurrentHashMap.KeySetView<WorkerStatusListener, Boolean> workerStatusListeners() {
        return this.workerStatusListeners;
    }

    public ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> excludedWorkers() {
        return this.excludedWorkers;
    }

    public Set<WorkerInfo> shuttingWorkers() {
        return this.shuttingWorkers;
    }

    public void registerWorkerStatusListener(WorkerStatusListener workerStatusListener) {
        this.workerStatusListeners().add(workerStatusListener);
    }

    public scala.collection.immutable.Set<WorkerInfo> getNeedCheckedWorkers() {
        return this.conf.clientCheckedUseAllocatedWorkers() ? this.lifecycleManager.getAllocatedWorkers() : (scala.collection.immutable.Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).keys().toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).toSet());
    }

    public boolean workerAvailable(WorkerInfo worker) {
        return !this.excludedWorkers().containsKey(worker) && !this.shuttingWorkers().contains(worker);
    }

    public boolean workerAvailable(PartitionLocation loc) {
        return loc == null ? false : this.workerAvailable(loc.getWorker());
    }

    public void excludeWorkerFromPartition(int shuffleId, PartitionLocation oldPartition, StatusCode cause) {
        ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failedWorker = new ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>>();
        if (oldPartition != null) {
            StatusCode statusCode = cause;
            if (((Object)((Object)StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_TIMEOUT_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_TIMEOUT_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        this.recordWorkerFailure(failedWorker);
    }

    public void recordWorkerFailure(ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failures) {
        block0: {
            if (failures.isEmpty()) break block0;
            ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failedWorker = new ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>>(failures);
            String failedWorkerMsg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(failedWorker).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                WorkerInfo worker;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        worker = (WorkerInfo)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                StatusCode status = (StatusCode)((Object)((Object)tuple2._1()));
                long time = tuple2._2$mcJ$sp();
                String string = new StringBuilder(6).append(worker.readableAddress()).append("   ").append(status.name()).append("   ").append(time).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            String excludedWorkerMsg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2;
                WorkerInfo worker;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        worker = (WorkerInfo)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                StatusCode status = (StatusCode)((Object)((Object)tuple2._1()));
                long time = tuple2._2$mcJ$sp();
                String string = new StringBuilder(6).append(worker.readableAddress()).append("   ").append(status.name()).append("   ").append(time).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            String shuttingDownMsg = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.readableAddress(), Set$.MODULE$.canBuildFrom())).mkString("\n");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n           |Reporting failed worker:\n           |").append(failedWorkerMsg).append("\n           |Current excluded worker:\n           |").append(excludedWorkerMsg).append("\n           |Current shutting down worker:\n           |").append(shuttingDownMsg).toString())).stripMargin());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(failedWorker).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                StatusCode statusCode;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    StatusCode statusCode2;
                    WorkerInfo worker = (WorkerInfo)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null && ((Object)((Object)StatusCode.WORKER_SHUTDOWN)).equals((Object)(statusCode2 = (StatusCode)((Object)((Object)tuple22._1()))))) {
                        return BoxesRunTime.boxToBoolean((boolean)this.shuttingWorkers().add(worker));
                    }
                }
                if (tuple2 != null) {
                    WorkerInfo worker = (WorkerInfo)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple23 != null) {
                        StatusCode statusCode3 = (StatusCode)((Object)((Object)tuple23._1()));
                        long registerTime = tuple23._2$mcJ$sp();
                        if (!this.excludedWorkers().containsKey(worker)) {
                            return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode3, (Object)BoxesRunTime.boxToLong((long)registerTime)));
                        }
                    }
                }
                if (tuple2 == null) return BoxedUnit.UNIT;
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 == null) return BoxedUnit.UNIT;
                StatusCode statusCode4 = statusCode = (StatusCode)((Object)((Object)tuple24._1()));
                StatusCode statusCode5 = StatusCode.NO_AVAILABLE_WORKING_DIR;
                if (statusCode4 == null) {
                    if (statusCode5 == null) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                } else if (((Object)((Object)statusCode4)).equals((Object)statusCode5)) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                StatusCode statusCode6 = statusCode;
                StatusCode statusCode7 = StatusCode.RESERVE_SLOTS_FAILED;
                if (statusCode6 == null) {
                    if (statusCode7 == null) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                } else if (((Object)((Object)statusCode6)).equals((Object)statusCode7)) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                StatusCode statusCode8 = statusCode;
                StatusCode statusCode9 = StatusCode.WORKER_UNKNOWN;
                if (statusCode8 != null) {
                    if (!((Object)((Object)statusCode8)).equals((Object)statusCode9)) return BoxedUnit.UNIT;
                    return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                }
                if (statusCode9 == null) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                return BoxedUnit.UNIT;
            });
        }
    }

    public void removeFromExcludedWorkers(HashSet<WorkerInfo> workers) {
        ((ConcurrentHashMap.KeySetView)this.excludedWorkers().keySet()).removeAll(workers);
    }

    public void handleHeartbeatResponse(ControlMessages.HeartbeatFromApplicationResponse res) {
        block2: {
            StatusCode statusCode = res.statusCode();
            StatusCode statusCode2 = StatusCode.SUCCESS;
            if (statusCode != null ? !((Object)((Object)statusCode)).equals((Object)statusCode2) : statusCode2 != null) break block2;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Received Worker status from Primary, excluded workers: ").append(res.excludedWorkers()).append(" ").append("unknown workers: ").append(res.unknownWorkers()).append(", shutdown workers: ").append(res.shuttingWorkers()).toString());
            long current = System.currentTimeMillis();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WorkerInfo workerInfo;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        WorkerInfo workerInfo2 = (WorkerInfo)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (workerInfo2 == null) break block2;
                        workerInfo = workerInfo2;
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                StatusCode statusCode = (StatusCode)((Object)((Object)tuple2._1()));
                long registerTime = tuple2._2$mcJ$sp();
                StatusCode statusCode2 = statusCode;
                boolean bl = ((Object)((Object)StatusCode.WORKER_UNKNOWN)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.NO_AVAILABLE_WORKING_DIR)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.RESERVE_SLOTS_FAILED)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_PRIMARY)).equals((Object)statusCode2) ? true : ((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_REPLICA)).equals((Object)statusCode2))))))));
                Object object = bl && current - registerTime < this.excludedWorkerExpireTimeout() ? BoxedUnit.UNIT : (!res.excludedWorkers().contains(workerInfo) && !res.shuttingWorkers().contains(workerInfo) && !res.unknownWorkers().contains(workerInfo) ? this.excludedWorkers().remove(workerInfo) : BoxedUnit.UNIT);
                Tuple2<StatusCode, Object> tuple23 = object;
                return tuple23;
            });
            if (!res.excludedWorkers().isEmpty()) {
                this.excludedWorkers().putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.excludedWorkers()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerStatusTracker.$anonfun$handleHeartbeatResponse$3(this, x$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StatusCode.WORKER_EXCLUDED), (Object)BoxesRunTime.boxToLong((long)current))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
            }
            this.shuttingWorkers().retainAll(res.shuttingWorkers());
            this.shuttingWorkers().addAll(res.shuttingWorkers());
            if (!res.unknownWorkers().isEmpty() || !res.shuttingWorkers().isEmpty()) {
                this.excludedWorkers().putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.unknownWorkers()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerStatusTracker.$anonfun$handleHeartbeatResponse$5(this, x$1)))).map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StatusCode.WORKER_UNKNOWN), (Object)BoxesRunTime.boxToLong((long)current))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
                WorkersStatus workerStatus = new WorkersStatus(res.unknownWorkers(), res.shuttingWorkers());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.workerStatusListeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
                    WorkerStatusTracker.$anonfun$handleHeartbeatResponse$7(this, workerStatus, listener);
                    return BoxedUnit.UNIT;
                });
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Current excluded workers ").append(this.excludedWorkers()).append(", Current shuttingDown ").append(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.readableAddress(), Set$.MODULE$.canBuildFrom())).mkString("\n")).toString());
        }
    }

    private final void excludeWorker$1(PartitionLocation partition, StatusCode statusCode, int shuffleId$1, ConcurrentHashMap failedWorker$1) {
        block0: {
            WorkerInfo tmpWorker = partition.getWorker();
            Option worker = ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.lifecycleManager.workerSnapshots(shuffleId$1).keySet()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(tmpWorker)));
            if (!worker.isDefined()) break block0;
            failedWorker$1.put(worker.get(), new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleHeartbeatResponse$3(WorkerStatusTracker $this, Object x$1) {
        return $this.excludedWorkers().containsKey(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$handleHeartbeatResponse$5(WorkerStatusTracker $this, Object x$1) {
        return $this.excludedWorkers().containsKey(x$1);
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$7(WorkerStatusTracker $this, WorkersStatus workerStatus$1, WorkerStatusListener listener) {
        try {
            listener.notifyChangedWorkersStatus(workerStatus$1);
        }
        catch (Throwable t) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while notify listener", t);
        }
    }

    public WorkerStatusTracker(CelebornConf conf, LifecycleManager lifecycleManager) {
        this.conf = conf;
        this.lifecycleManager = lifecycleManager;
        Logging.$init$(this);
        this.excludedWorkerExpireTimeout = conf.clientExcludedWorkerExpireTimeout();
        this.workerStatusListeners = ConcurrentHashMap.newKeySet();
        this.excludedWorkers = new ConcurrentHashMap();
        this.shuttingWorkers = new HashSet<WorkerInfo>();
    }
}

