/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CostProvider;
import org.apache.hadoop.ipc.DecayRpcSchedulerMXBean;
import org.apache.hadoop.ipc.DefaultCostProvider;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.RpcScheduler;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.metrics2.util.Metrics2Util;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hadoop.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.AtomicDoubleArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecayRpcScheduler
implements RpcScheduler,
DecayRpcSchedulerMXBean,
MetricsSource {
    public static final String IPC_SCHEDULER_DECAYSCHEDULER_PERIOD_KEY = "decay-scheduler.period-ms";
    public static final long IPC_SCHEDULER_DECAYSCHEDULER_PERIOD_DEFAULT = 5000L;
    @Deprecated
    public static final String IPC_FCQ_DECAYSCHEDULER_PERIOD_KEY = "faircallqueue.decay-scheduler.period-ms";
    public static final String IPC_SCHEDULER_DECAYSCHEDULER_FACTOR_KEY = "decay-scheduler.decay-factor";
    public static final double IPC_SCHEDULER_DECAYSCHEDULER_FACTOR_DEFAULT = 0.5;
    @Deprecated
    public static final String IPC_FCQ_DECAYSCHEDULER_FACTOR_KEY = "faircallqueue.decay-scheduler.decay-factor";
    public static final String IPC_DECAYSCHEDULER_THRESHOLDS_KEY = "decay-scheduler.thresholds";
    @Deprecated
    public static final String IPC_FCQ_DECAYSCHEDULER_THRESHOLDS_KEY = "faircallqueue.decay-scheduler.thresholds";
    public static final String DECAYSCHEDULER_UNKNOWN_IDENTITY = "IdentityProvider.Unknown";
    public static final String IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_KEY = "decay-scheduler.backoff.responsetime.enable";
    public static final Boolean IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_DEFAULT = false;
    public static final String IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_THRESHOLDS_KEY = "decay-scheduler.backoff.responsetime.thresholds";
    public static final String DECAYSCHEDULER_METRICS_TOP_USER_COUNT = "decay-scheduler.metrics.top.user.count";
    public static final int DECAYSCHEDULER_METRICS_TOP_USER_COUNT_DEFAULT = 10;
    public static final Logger LOG = LoggerFactory.getLogger(DecayRpcScheduler.class);
    private static final ObjectWriter WRITER = new ObjectMapper().writer();
    private final ConcurrentHashMap<Object, List<AtomicLong>> callCosts = new ConcurrentHashMap();
    private final AtomicLong totalDecayedCallCost = new AtomicLong();
    private final AtomicLong totalRawCallCost = new AtomicLong();
    private final AtomicLongArray responseTimeCountInCurrWindow;
    private final AtomicLongArray responseTimeTotalInCurrWindow;
    private final AtomicDoubleArray responseTimeAvgInLastWindow;
    private final AtomicLongArray responseTimeCountInLastWindow;
    private final AtomicReference<Map<Object, Integer>> scheduleCacheRef = new AtomicReference();
    private final long decayPeriodMillis;
    private final double decayFactor;
    private final int numLevels;
    private final double[] thresholds;
    private final IdentityProvider identityProvider;
    private final boolean backOffByResponseTimeEnabled;
    private final long[] backOffResponseTimeThresholds;
    private final String namespace;
    private final int topUsersCount;
    private static final double PRECISION = 1.0E-4;
    private MetricsProxy metricsProxy;
    private final CostProvider costProvider;

    public DecayRpcScheduler(int numLevels, String ns, Configuration conf) {
        if (numLevels < 1) {
            throw new IllegalArgumentException("Number of Priority Levels must be at least 1");
        }
        this.numLevels = numLevels;
        this.namespace = ns;
        this.decayFactor = DecayRpcScheduler.parseDecayFactor(ns, conf);
        this.decayPeriodMillis = DecayRpcScheduler.parseDecayPeriodMillis(ns, conf);
        this.identityProvider = this.parseIdentityProvider(ns, conf);
        this.costProvider = this.parseCostProvider(ns, conf);
        this.thresholds = DecayRpcScheduler.parseThresholds(ns, conf, numLevels);
        this.backOffByResponseTimeEnabled = DecayRpcScheduler.parseBackOffByResponseTimeEnabled(ns, conf);
        this.backOffResponseTimeThresholds = DecayRpcScheduler.parseBackOffResponseTimeThreshold(ns, conf, numLevels);
        this.responseTimeTotalInCurrWindow = new AtomicLongArray(numLevels);
        this.responseTimeCountInCurrWindow = new AtomicLongArray(numLevels);
        this.responseTimeAvgInLastWindow = new AtomicDoubleArray(numLevels);
        this.responseTimeCountInLastWindow = new AtomicLongArray(numLevels);
        this.topUsersCount = conf.getInt(DECAYSCHEDULER_METRICS_TOP_USER_COUNT, 10);
        Preconditions.checkArgument((this.topUsersCount > 0 ? 1 : 0) != 0, (Object)"the number of top users for scheduler metrics must be at least 1");
        Timer timer = new Timer();
        DecayTask task = new DecayTask(this, timer);
        timer.scheduleAtFixedRate((TimerTask)task, this.decayPeriodMillis, this.decayPeriodMillis);
        this.metricsProxy = MetricsProxy.getInstance(ns, numLevels, this);
        this.recomputeScheduleCache();
    }

    private CostProvider parseCostProvider(String ns, Configuration conf) {
        List<CostProvider> providers = conf.getInstances(ns + "." + "cost-provider.impl", CostProvider.class);
        if (providers.size() < 1) {
            LOG.info("CostProvider not specified, defaulting to DefaultCostProvider");
            return new DefaultCostProvider();
        }
        if (providers.size() > 1) {
            LOG.warn("Found multiple CostProviders; using: {}", providers.get(0).getClass());
        }
        CostProvider provider = providers.get(0);
        provider.init(ns, conf);
        return provider;
    }

    private IdentityProvider parseIdentityProvider(String ns, Configuration conf) {
        List<IdentityProvider> providers = conf.getInstances(ns + "." + "identity-provider.impl", IdentityProvider.class);
        if (providers.size() < 1) {
            LOG.info("IdentityProvider not specified, defaulting to UserIdentityProvider");
            return new UserIdentityProvider();
        }
        return providers.get(0);
    }

    private static double parseDecayFactor(String ns, Configuration conf) {
        double factor = conf.getDouble(ns + "." + IPC_FCQ_DECAYSCHEDULER_FACTOR_KEY, 0.0);
        if (factor == 0.0) {
            factor = conf.getDouble(ns + "." + IPC_SCHEDULER_DECAYSCHEDULER_FACTOR_KEY, 0.5);
        } else if (factor > 0.0 && factor < 1.0) {
            LOG.warn("faircallqueue.decay-scheduler.decay-factor is deprecated. Please use decay-scheduler.decay-factor.");
        }
        if (factor <= 0.0 || factor >= 1.0) {
            throw new IllegalArgumentException("Decay Factor must be between 0 and 1");
        }
        return factor;
    }

    private static long parseDecayPeriodMillis(String ns, Configuration conf) {
        long period = conf.getLong(ns + "." + IPC_FCQ_DECAYSCHEDULER_PERIOD_KEY, 0L);
        if (period == 0L) {
            period = conf.getLong(ns + "." + IPC_SCHEDULER_DECAYSCHEDULER_PERIOD_KEY, 5000L);
        } else if (period > 0L) {
            LOG.warn("faircallqueue.decay-scheduler.period-ms is deprecated. Please use decay-scheduler.period-ms");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Period millis must be >= 0");
        }
        return period;
    }

    private static double[] parseThresholds(String ns, Configuration conf, int numLevels) {
        int[] percentages = conf.getInts(ns + "." + IPC_FCQ_DECAYSCHEDULER_THRESHOLDS_KEY);
        if (percentages.length == 0) {
            percentages = conf.getInts(ns + "." + IPC_DECAYSCHEDULER_THRESHOLDS_KEY);
            if (percentages.length == 0) {
                return DecayRpcScheduler.getDefaultThresholds(numLevels);
            }
        } else {
            LOG.warn("faircallqueue.decay-scheduler.thresholds is deprecated. Please use decay-scheduler.thresholds");
        }
        if (percentages.length != numLevels - 1) {
            throw new IllegalArgumentException("Number of thresholds should be " + (numLevels - 1) + ". Was: " + percentages.length);
        }
        double[] decimals = new double[percentages.length];
        for (int i = 0; i < percentages.length; ++i) {
            decimals[i] = (double)percentages[i] / 100.0;
        }
        return decimals;
    }

    private static double[] getDefaultThresholds(int numLevels) {
        double[] ret = new double[numLevels - 1];
        double div = Math.pow(2.0, numLevels - 1);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.pow(2.0, i) / div;
        }
        return ret;
    }

    private static long[] parseBackOffResponseTimeThreshold(String ns, Configuration conf, int numLevels) {
        long[] responseTimeThresholds = conf.getTimeDurations(ns + "." + IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_THRESHOLDS_KEY, TimeUnit.MILLISECONDS);
        if (responseTimeThresholds.length == 0) {
            return DecayRpcScheduler.getDefaultBackOffResponseTimeThresholds(numLevels);
        }
        if (responseTimeThresholds.length != numLevels) {
            throw new IllegalArgumentException("responseTimeThresholds must match with the number of priority levels");
        }
        for (long responseTimeThreshold : responseTimeThresholds) {
            if (responseTimeThreshold > 0L) continue;
            throw new IllegalArgumentException("responseTimeThreshold millis must be >= 0");
        }
        return responseTimeThresholds;
    }

    private static long[] getDefaultBackOffResponseTimeThresholds(int numLevels) {
        long[] ret = new long[numLevels];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = 10000 * (i + 1);
        }
        return ret;
    }

    private static Boolean parseBackOffByResponseTimeEnabled(String ns, Configuration conf) {
        return conf.getBoolean(ns + "." + IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_KEY, IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_DEFAULT);
    }

    private void decayCurrentCosts() {
        LOG.debug("Start to decay current costs.");
        try {
            long totalDecayedCost = 0L;
            long totalRawCost = 0L;
            Iterator<Map.Entry<Object, List<AtomicLong>>> it = this.callCosts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, List<AtomicLong>> entry = it.next();
                AtomicLong decayedCost = entry.getValue().get(0);
                AtomicLong rawCost = entry.getValue().get(1);
                totalRawCost += rawCost.get();
                long currentValue = decayedCost.get();
                long nextValue = (long)((double)currentValue * this.decayFactor);
                totalDecayedCost += nextValue;
                decayedCost.set(nextValue);
                LOG.debug("Decaying costs for the user: {}, its decayedCost: {}, rawCost: {}", new Object[]{entry.getKey(), nextValue, rawCost.get()});
                if (nextValue != 0L) continue;
                LOG.debug("The decayed cost for the user {} is zero and being cleaned.", entry.getKey());
                it.remove();
            }
            this.totalDecayedCallCost.set(totalDecayedCost);
            this.totalRawCallCost.set(totalRawCost);
            LOG.debug("After decaying the stored costs, totalDecayedCost: {}, totalRawCallCost: {}.", (Object)totalDecayedCost, (Object)totalRawCost);
            this.recomputeScheduleCache();
            this.updateAverageResponseTime(true);
        }
        catch (Exception ex) {
            LOG.error("decayCurrentCosts exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            throw ex;
        }
    }

    private void recomputeScheduleCache() {
        HashMap<Object, Integer> nextCache = new HashMap<Object, Integer>();
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCosts.entrySet()) {
            Object id = entry.getKey();
            AtomicLong value = entry.getValue().get(0);
            long snapshot = value.get();
            int computedLevel = this.computePriorityLevel(snapshot);
            nextCache.put(id, computedLevel);
        }
        this.scheduleCacheRef.set(Collections.unmodifiableMap(nextCache));
    }

    private void addCost(Object identity, long costDelta) {
        List<AtomicLong> cost = this.callCosts.get(identity);
        if (cost == null) {
            cost = new ArrayList<AtomicLong>(2);
            cost.add(new AtomicLong(0L));
            cost.add(new AtomicLong(0L));
            List<AtomicLong> otherCost = this.callCosts.putIfAbsent(identity, cost);
            if (otherCost != null) {
                cost = otherCost;
            }
        }
        this.totalDecayedCallCost.getAndAdd(costDelta);
        this.totalRawCallCost.getAndAdd(costDelta);
        cost.get(1).getAndAdd(costDelta);
        cost.get(0).getAndAdd(costDelta);
    }

    private int computePriorityLevel(long cost) {
        long totalCallSnapshot = this.totalDecayedCallCost.get();
        double proportion = 0.0;
        if (totalCallSnapshot > 0L) {
            proportion = (double)cost / (double)totalCallSnapshot;
        }
        for (int i = this.numLevels - 1; i > 0; --i) {
            if (!(proportion >= this.thresholds[i - 1])) continue;
            return i;
        }
        return 0;
    }

    private int cachedOrComputedPriorityLevel(Object identity) {
        Integer priority;
        Map<Object, Integer> scheduleCache = this.scheduleCacheRef.get();
        if (scheduleCache != null && (priority = scheduleCache.get(identity)) != null) {
            LOG.debug("Cache priority for: {} with priority: {}", identity, (Object)priority);
            return priority;
        }
        List<AtomicLong> costList = this.callCosts.get(identity);
        long currentCost = costList == null ? 0L : costList.get(0).get();
        int priority2 = this.computePriorityLevel(currentCost);
        LOG.debug("compute priority for {} priority {}", identity, (Object)priority2);
        return priority2;
    }

    @Override
    public int getPriorityLevel(Schedulable obj) {
        String identity = this.identityProvider.makeIdentity(obj);
        if (identity == null) {
            identity = DECAYSCHEDULER_UNKNOWN_IDENTITY;
        }
        return this.cachedOrComputedPriorityLevel(identity);
    }

    @Override
    public boolean shouldBackOff(Schedulable obj) {
        Boolean backOff = false;
        if (this.backOffByResponseTimeEnabled) {
            int priorityLevel = obj.getPriorityLevel();
            if (LOG.isDebugEnabled()) {
                double[] responseTimes = this.getAverageResponseTime();
                LOG.debug("Current Caller: {}  Priority: {} ", (Object)obj.getUserGroupInformation().getUserName(), (Object)obj.getPriorityLevel());
                for (int i = 0; i < this.numLevels; ++i) {
                    LOG.debug("Queue: {} responseTime: {} backoffThreshold: {}", new Object[]{i, responseTimes[i], this.backOffResponseTimeThresholds[i]});
                }
            }
            for (int i = 0; i < priorityLevel + 1; ++i) {
                if (!(this.responseTimeAvgInLastWindow.get(i) > (double)this.backOffResponseTimeThresholds[i])) continue;
                backOff = true;
                break;
            }
        }
        return backOff;
    }

    @Override
    public void addResponseTime(String callName, Schedulable schedulable, ProcessingDetails details) {
        String user = this.identityProvider.makeIdentity(schedulable);
        long processingCost = this.costProvider.getCost(details);
        this.addCost(user, processingCost);
        int priorityLevel = schedulable.getPriorityLevel();
        long queueTime = details.get(ProcessingDetails.Timing.QUEUE, TimeUnit.MILLISECONDS);
        long processingTime = details.get(ProcessingDetails.Timing.PROCESSING, TimeUnit.MILLISECONDS);
        this.responseTimeCountInCurrWindow.getAndIncrement(priorityLevel);
        this.responseTimeTotalInCurrWindow.getAndAdd(priorityLevel, queueTime + processingTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("addResponseTime for call: {}  priority: {} queueTime: {} processingTime: {} ", new Object[]{callName, priorityLevel, queueTime, processingTime});
        }
    }

    void updateAverageResponseTime(boolean enableDecay) {
        for (int i = 0; i < this.numLevels; ++i) {
            double lastAvg;
            double averageResponseTime = 0.0;
            long totalResponseTime = this.responseTimeTotalInCurrWindow.get(i);
            long responseTimeCount = this.responseTimeCountInCurrWindow.get(i);
            if (responseTimeCount > 0L) {
                averageResponseTime = (double)totalResponseTime / (double)responseTimeCount;
            }
            if ((lastAvg = this.responseTimeAvgInLastWindow.get(i)) > 1.0E-4 || averageResponseTime > 1.0E-4) {
                if (enableDecay) {
                    double decayed = this.decayFactor * lastAvg + averageResponseTime;
                    this.responseTimeAvgInLastWindow.set(i, decayed);
                } else {
                    this.responseTimeAvgInLastWindow.set(i, averageResponseTime);
                }
            } else {
                this.responseTimeAvgInLastWindow.set(i, 0.0);
            }
            this.responseTimeCountInLastWindow.set(i, responseTimeCount);
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateAverageResponseTime queue: {} Average: {} Count: {}", new Object[]{i, averageResponseTime, responseTimeCount});
            }
            this.responseTimeTotalInCurrWindow.set(i, 0L);
            this.responseTimeCountInCurrWindow.set(i, 0L);
        }
    }

    @VisibleForTesting
    double getDecayFactor() {
        return this.decayFactor;
    }

    @VisibleForTesting
    long getDecayPeriodMillis() {
        return this.decayPeriodMillis;
    }

    @VisibleForTesting
    double[] getThresholds() {
        return this.thresholds;
    }

    @VisibleForTesting
    void forceDecay() {
        this.decayCurrentCosts();
    }

    @VisibleForTesting
    Map<Object, Long> getCallCostSnapshot() {
        HashMap<Object, Long> snapshot = new HashMap<Object, Long>();
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCosts.entrySet()) {
            snapshot.put(entry.getKey(), entry.getValue().get(0).get());
        }
        return Collections.unmodifiableMap(snapshot);
    }

    @VisibleForTesting
    long getTotalCallSnapshot() {
        return this.totalDecayedCallCost.get();
    }

    @Override
    public int getUniqueIdentityCount() {
        return this.callCosts.size();
    }

    @Override
    public long getTotalCallVolume() {
        return this.totalDecayedCallCost.get();
    }

    public long getTotalRawCallVolume() {
        return this.totalRawCallCost.get();
    }

    @Override
    public long[] getResponseTimeCountInLastWindow() {
        long[] ret = new long[this.responseTimeCountInLastWindow.length()];
        for (int i = 0; i < this.responseTimeCountInLastWindow.length(); ++i) {
            ret[i] = this.responseTimeCountInLastWindow.get(i);
        }
        return ret;
    }

    @Override
    public double[] getAverageResponseTime() {
        double[] ret = new double[this.responseTimeAvgInLastWindow.length()];
        for (int i = 0; i < this.responseTimeAvgInLastWindow.length(); ++i) {
            ret[i] = this.responseTimeAvgInLastWindow.get(i);
        }
        return ret;
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        try {
            MetricsRecordBuilder rb = collector.addRecord(this.getClass().getName()).setContext(this.namespace);
            this.addDecayedCallVolume(rb);
            this.addUniqueIdentityCount(rb);
            this.addTopNCallerSummary(rb);
            this.addAvgResponseTimePerPriority(rb);
            this.addCallVolumePerPriority(rb);
            this.addRawCallVolume(rb);
        }
        catch (Exception e) {
            LOG.warn("Exception thrown while metric collection. Exception : " + e.getMessage());
        }
    }

    private void addUniqueIdentityCount(MetricsRecordBuilder rb) {
        rb.addCounter(Interns.info("UniqueCallers", "Total unique callers"), this.getUniqueIdentityCount());
    }

    private void addDecayedCallVolume(MetricsRecordBuilder rb) {
        rb.addCounter(Interns.info("DecayedCallVolume", "Decayed Total incoming Call Volume"), this.getTotalCallVolume());
    }

    private void addRawCallVolume(MetricsRecordBuilder rb) {
        rb.addCounter(Interns.info("CallVolume", "Raw Total incoming Call Volume"), this.getTotalRawCallVolume());
    }

    private void addCallVolumePerPriority(MetricsRecordBuilder rb) {
        for (int i = 0; i < this.responseTimeCountInLastWindow.length(); ++i) {
            rb.addGauge(Interns.info("Priority." + i + ".CompletedCallVolume", "Completed Call volume of priority " + i), this.responseTimeCountInLastWindow.get(i));
        }
    }

    private void addAvgResponseTimePerPriority(MetricsRecordBuilder rb) {
        for (int i = 0; i < this.responseTimeAvgInLastWindow.length(); ++i) {
            rb.addGauge(Interns.info("Priority." + i + ".AvgResponseTime", "Average response time of priority " + i), this.responseTimeAvgInLastWindow.get(i));
        }
    }

    private void addTopNCallerSummary(MetricsRecordBuilder rb) {
        Metrics2Util.TopN topNCallers = this.getTopCallers(this.topUsersCount);
        Map<Object, Integer> decisions = this.scheduleCacheRef.get();
        int actualCallerCount = topNCallers.size();
        for (int i = 0; i < actualCallerCount; ++i) {
            Metrics2Util.NameValuePair entry = (Metrics2Util.NameValuePair)topNCallers.poll();
            String topCaller = "Caller(" + entry.getName() + ")";
            String topCallerVolume = topCaller + ".Volume";
            String topCallerPriority = topCaller + ".Priority";
            rb.addCounter(Interns.info(topCallerVolume, topCallerVolume), entry.getValue());
            Integer priority = decisions.get(entry.getName());
            if (priority == null) continue;
            rb.addCounter(Interns.info(topCallerPriority, topCallerPriority), priority);
        }
    }

    private Metrics2Util.TopN getTopCallers(int n) {
        Metrics2Util.TopN topNCallers = new Metrics2Util.TopN(n);
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCosts.entrySet()) {
            String caller = entry.getKey().toString();
            Long cost = entry.getValue().get(1).get();
            if (cost <= 0L) continue;
            topNCallers.offer(new Metrics2Util.NameValuePair(caller, cost));
        }
        return topNCallers;
    }

    @Override
    public String getSchedulingDecisionSummary() {
        Map<Object, Integer> decisions = this.scheduleCacheRef.get();
        if (decisions == null) {
            return "{}";
        }
        try {
            return WRITER.writeValueAsString(decisions);
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    @Override
    public String getCallVolumeSummary() {
        try {
            return WRITER.writeValueAsString(this.getDecayedCallCosts());
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    private Map<Object, Long> getDecayedCallCosts() {
        HashMap<Object, Long> decayedCallCosts = new HashMap<Object, Long>(this.callCosts.size());
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCosts.entrySet()) {
            Object user = entry.getKey();
            Long decayedCost = entry.getValue().get(0).get();
            if (decayedCost <= 0L) continue;
            decayedCallCosts.put(user, decayedCost);
        }
        return decayedCallCosts;
    }

    @Override
    public void stop() {
        this.metricsProxy.unregisterSource(this.namespace);
        MetricsProxy.removeInstance(this.namespace);
    }

    public static final class MetricsProxy
    implements DecayRpcSchedulerMXBean,
    MetricsSource {
        private static final HashMap<String, MetricsProxy> INSTANCES = new HashMap();
        private WeakReference<DecayRpcScheduler> delegate;
        private double[] averageResponseTimeDefault;
        private long[] callCountInLastWindowDefault;
        private ObjectName decayRpcSchedulerInfoBeanName;

        private MetricsProxy(String namespace, int numLevels, DecayRpcScheduler drs) {
            this.averageResponseTimeDefault = new double[numLevels];
            this.callCountInLastWindowDefault = new long[numLevels];
            this.setDelegate(drs);
            this.decayRpcSchedulerInfoBeanName = MBeans.register(namespace, "DecayRpcScheduler", this);
            this.registerMetrics2Source(namespace);
        }

        public static synchronized MetricsProxy getInstance(String namespace, int numLevels, DecayRpcScheduler drs) {
            MetricsProxy mp = INSTANCES.get(namespace);
            if (mp == null) {
                mp = new MetricsProxy(namespace, numLevels, drs);
                INSTANCES.put(namespace, mp);
            } else if (drs != mp.delegate.get()) {
                mp.setDelegate(drs);
            }
            return mp;
        }

        public static synchronized void removeInstance(String namespace) {
            INSTANCES.remove(namespace);
        }

        public void setDelegate(DecayRpcScheduler obj) {
            this.delegate = new WeakReference<DecayRpcScheduler>(obj);
        }

        void registerMetrics2Source(String namespace) {
            String name = "DecayRpcSchedulerMetrics2." + namespace;
            DefaultMetricsSystem.instance().register(name, name, this);
        }

        void unregisterSource(String namespace) {
            String name = "DecayRpcSchedulerMetrics2." + namespace;
            DefaultMetricsSystem.instance().unregisterSource(name);
            if (this.decayRpcSchedulerInfoBeanName != null) {
                MBeans.unregister(this.decayRpcSchedulerInfoBeanName);
            }
        }

        @Override
        public String getSchedulingDecisionSummary() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return "No Active Scheduler";
            }
            return scheduler.getSchedulingDecisionSummary();
        }

        @Override
        public String getCallVolumeSummary() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return "No Active Scheduler";
            }
            return scheduler.getCallVolumeSummary();
        }

        @Override
        public int getUniqueIdentityCount() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return -1;
            }
            return scheduler.getUniqueIdentityCount();
        }

        @Override
        public long getTotalCallVolume() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return -1L;
            }
            return scheduler.getTotalCallVolume();
        }

        @Override
        public double[] getAverageResponseTime() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return this.averageResponseTimeDefault;
            }
            return scheduler.getAverageResponseTime();
        }

        @Override
        public long[] getResponseTimeCountInLastWindow() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return this.callCountInLastWindowDefault;
            }
            return scheduler.getResponseTimeCountInLastWindow();
        }

        @Override
        public void getMetrics(MetricsCollector collector, boolean all) {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler != null) {
                scheduler.getMetrics(collector, all);
            }
        }
    }

    public static class DecayTask
    extends TimerTask {
        private WeakReference<DecayRpcScheduler> schedulerRef;
        private Timer timer;

        public DecayTask(DecayRpcScheduler scheduler, Timer timer) {
            this.schedulerRef = new WeakReference<DecayRpcScheduler>(scheduler);
            this.timer = timer;
        }

        @Override
        public void run() {
            DecayRpcScheduler sched = (DecayRpcScheduler)this.schedulerRef.get();
            if (sched != null) {
                sched.decayCurrentCosts();
            } else {
                this.timer.cancel();
                this.timer.purge();
            }
        }
    }
}

