/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.util.LongBitFormat;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PipelineAck {
    DataTransferProtos.PipelineAckProto proto;
    public static final long UNKOWN_SEQNO = -2L;
    static final int OOB_START = 8;
    static final int OOB_END = 11;

    public PipelineAck() {
    }

    public PipelineAck(long seqno, int[] replies) {
        this(seqno, replies, 0L);
    }

    public PipelineAck(long seqno, int[] replies, long downstreamAckTimeNanos) {
        ArrayList statusList = Lists.newArrayList();
        ArrayList flagList = Lists.newArrayList();
        for (int r : replies) {
            statusList.add(StatusFormat.getStatus(r));
            flagList.add(r);
        }
        this.proto = DataTransferProtos.PipelineAckProto.newBuilder().setSeqno(seqno).addAllReply(statusList).addAllFlag(flagList).setDownstreamAckTimeNanos(downstreamAckTimeNanos).build();
    }

    public long getSeqno() {
        return this.proto.getSeqno();
    }

    public short getNumOfReplies() {
        return (short)this.proto.getReplyCount();
    }

    public int getHeaderFlag(int i) {
        if (this.proto.getFlagCount() > 0) {
            return this.proto.getFlag(i);
        }
        return PipelineAck.combineHeader(ECN.DISABLED, this.proto.getReply(i));
    }

    public int getFlag(int i) {
        return this.proto.getFlag(i);
    }

    public long getDownstreamAckTimeNanos() {
        return this.proto.getDownstreamAckTimeNanos();
    }

    public boolean isSuccess() {
        for (DataTransferProtos.Status s : this.proto.getReplyList()) {
            if (s == DataTransferProtos.Status.SUCCESS) continue;
            return false;
        }
        return true;
    }

    public DataTransferProtos.Status getOOBStatus() {
        if (this.getSeqno() != -2L) {
            return null;
        }
        for (DataTransferProtos.Status s : this.proto.getReplyList()) {
            if (s.getNumber() < 8 || s.getNumber() > 11) continue;
            return s;
        }
        return null;
    }

    public static DataTransferProtos.Status getRestartOOBStatus() {
        return DataTransferProtos.Status.OOB_RESTART;
    }

    public static boolean isRestartOOBStatus(DataTransferProtos.Status st) {
        return st.equals((Object)DataTransferProtos.Status.OOB_RESTART);
    }

    public void readFields(InputStream in) throws IOException {
        this.proto = DataTransferProtos.PipelineAckProto.parseFrom(PBHelperClient.vintPrefixed(in));
    }

    public void write(OutputStream out) throws IOException {
        this.proto.writeDelimitedTo(out);
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.proto);
    }

    public static DataTransferProtos.Status getStatusFromHeader(int header) {
        return StatusFormat.getStatus(header);
    }

    public static ECN getECNFromHeader(int header) {
        return StatusFormat.getECN(header);
    }

    public static int setStatusForHeader(int old, DataTransferProtos.Status status) {
        return StatusFormat.setStatus(old, status);
    }

    public static int combineHeader(ECN ecn, DataTransferProtos.Status status) {
        int header = 0;
        header = StatusFormat.setStatus(header, status);
        header = StatusFormat.setECN(header, ecn);
        return header;
    }

    private static enum StatusFormat {
        STATUS(null, 4),
        RESERVED(StatusFormat.STATUS.BITS, 1),
        ECN_BITS(StatusFormat.RESERVED.BITS, 2);

        private final LongBitFormat BITS;

        private StatusFormat(LongBitFormat prev, int bits) {
            this.BITS = new LongBitFormat(this.name(), prev, bits, 0L);
        }

        static DataTransferProtos.Status getStatus(int header) {
            return DataTransferProtos.Status.valueOf((int)StatusFormat.STATUS.BITS.retrieve(header));
        }

        static ECN getECN(int header) {
            return ECN.valueOf((int)StatusFormat.ECN_BITS.BITS.retrieve(header));
        }

        public static int setStatus(int old, DataTransferProtos.Status status) {
            return (int)StatusFormat.STATUS.BITS.combine(status.getNumber(), old);
        }

        public static int setECN(int old, ECN ecn) {
            return (int)StatusFormat.ECN_BITS.BITS.combine(ecn.getValue(), old);
        }
    }

    public static enum ECN {
        DISABLED(0),
        SUPPORTED(1),
        SUPPORTED2(2),
        CONGESTED(3);

        private final int value;
        private static final ECN[] VALUES;

        static ECN valueOf(int value) {
            return VALUES[value];
        }

        private ECN(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            VALUES = ECN.values();
        }
    }
}

