/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.has.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.HasConfig;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.HasException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public class HasUtil {
    public static HasConfig getHasConfig(File hasConfFile) throws HasException {
        if (hasConfFile.exists()) {
            HasConfig hasConfig = new HasConfig();
            try {
                hasConfig.addIniConfig(hasConfFile);
            }
            catch (IOException e) {
                throw new HasException("Can not load the has configuration file " + hasConfFile.getAbsolutePath());
            }
            return hasConfig;
        }
        throw new HasException(hasConfFile.getName() + " not found in " + hasConfFile.getParent() + ". ");
    }

    public static void setEnableConf(File hasConfFile, String value) throws HasException, IOException {
        String oldValue = HasUtil.getHasConfig(hasConfFile).getEnableConf();
        if (oldValue == null) {
            throw new HasException("Please set enable_conf in has-server.conf.");
        }
        if (oldValue.equals(value)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader bf = new BufferedReader(new FileReader(hasConfFile));){
                String tempString;
                while ((tempString = bf.readLine()) != null) {
                    if (tempString.trim().startsWith("enable_conf")) {
                        tempString = tempString.replace(oldValue, value);
                    }
                    sb.append(tempString + "\n");
                }
            }
            var5_6 = null;
            try (PrintStream ps = new PrintStream(new FileOutputStream(hasConfFile));){
                ps.print(sb.toString());
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new HasException("Can not load the has configuration file " + hasConfFile.getAbsolutePath());
        }
    }

    public static EncryptionKey getClientKey(String userName, String passPhrase, EncryptionType type) throws KrbException {
        EncryptionKey clientKey = EncryptionHandler.string2Key(userName, passPhrase, type);
        return clientKey;
    }
}

