/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;

public final class JpegSyntaxChecker
extends SyntaxChecker {
    public static final JpegSyntaxChecker INSTANCE = new JpegSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.28");

    private JpegSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        if (!(value instanceof byte[])) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        byte[] bytes = (byte[])value;
        if (bytes.length < 11) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (bytes[0] == -1 && bytes[1] == -40 && bytes[2] == -1) {
            if (bytes[3] == -32 && bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70 && bytes[10] == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
                }
                return true;
            }
            if (bytes[3] == -31 && bytes[6] == 69 && bytes[7] == 120 && bytes[8] == 105 && bytes[9] == 102 && bytes[10] == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
                }
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
        }
        return false;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<JpegSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.28");
        }

        @Override
        public JpegSyntaxChecker build() {
            return new JpegSyntaxChecker(this.oid);
        }
    }
}

