/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Chars;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class IntegerSyntaxChecker
extends SyntaxChecker {
    public static final IntegerSyntaxChecker INSTANCE = new IntegerSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.27");

    private IntegerSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        boolean result;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        int pos = 0;
        char c = strValue.charAt(pos);
        if (c == '-') {
            pos = 1;
        } else {
            if (!Chars.isDigit(c)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
            if (c == '0') {
                if (strValue.length() > 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
                }
                return true;
            }
        }
        if (!Chars.isDigit(strValue, pos) || Strings.isCharASCII(strValue, pos, '0')) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        ++pos;
        while (Chars.isDigit(strValue, pos)) {
            ++pos;
        }
        boolean bl = result = pos == strValue.length();
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<IntegerSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.27");
        }

        @Override
        public IntegerSyntaxChecker build() {
            return new IntegerSyntaxChecker(this.oid);
        }
    }
}

