/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema;

import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;

public class LdapSyntax
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    protected boolean isHumanReadable = false;
    private boolean hasHumanReadableFlag = false;
    protected SyntaxChecker syntaxChecker;

    public LdapSyntax(String oid) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
    }

    public LdapSyntax(String oid, String description) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
        this.description = description;
        this.hasHumanReadableFlag = false;
        this.computeHashCode();
    }

    public LdapSyntax(String oid, String description, boolean isHumanReadable) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
        this.description = description;
        this.isHumanReadable = isHumanReadable;
        this.hasHumanReadableFlag = true;
        this.computeHashCode();
    }

    public boolean isHumanReadable() {
        if (this.hasHumanReadableFlag) {
            return this.isHumanReadable;
        }
        List<String> values = this.getExtension("X-NOT-HUMAN-READABLE");
        if (values == null || values.isEmpty()) {
            return true;
        }
        String value = values.get(0);
        this.hasHumanReadableFlag = true;
        if ("FALSE".equalsIgnoreCase(value)) {
            this.isHumanReadable = true;
            return true;
        }
        this.isHumanReadable = false;
        return false;
    }

    public void setHumanReadable(boolean humanReadable) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.isHumanReadable = humanReadable;
        this.hasHumanReadableFlag = true;
    }

    public SyntaxChecker getSyntaxChecker() {
        return this.syntaxChecker;
    }

    public void setSyntaxChecker(SyntaxChecker syntaxChecker) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.syntaxChecker = syntaxChecker;
    }

    public void updateSyntaxChecker(SyntaxChecker newSyntaxChecker) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.syntaxChecker = newSyntaxChecker;
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public LdapSyntax copy() {
        LdapSyntax copy = new LdapSyntax(this.oid);
        copy.copy(this);
        copy.isHumanReadable = this.isHumanReadable;
        copy.hasHumanReadableFlag = this.hasHumanReadableFlag;
        copy.syntaxChecker = null;
        return copy;
    }

    @Override
    public int hashCode() {
        int hash = this.h;
        hash = hash * 17 + (this.isHumanReadable ? 1 : 0);
        if (this.syntaxChecker != null) {
            hash = hash * 17 + this.syntaxChecker.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LdapSyntax)) {
            return false;
        }
        LdapSyntax that = (LdapSyntax)o;
        if (this.isHumanReadable != that.isHumanReadable) {
            return false;
        }
        if (this.syntaxChecker != null) {
            if (that.syntaxChecker == null) {
                return false;
            }
            return this.syntaxChecker.getOid().equals(that.syntaxChecker.getOid());
        }
        return that.syntaxChecker == null;
    }

    @Override
    public void clear() {
        super.clear();
        this.syntaxChecker = null;
    }
}

